/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.report.threadvisualizer;

import eu.tsystems.mms.tic.testframework.report.Report;
import eu.tsystems.mms.tic.testframework.report.TesterraListener;
import eu.tsystems.mms.tic.testframework.report.model.context.MethodContext;
import eu.tsystems.mms.tic.testframework.report.threadvisualizer.DataSet;
import eu.tsystems.mms.tic.testframework.report.threadvisualizer.DataStorage;
import eu.tsystems.mms.tic.testframework.report.threadvisualizer.ThreadVisualizerUtils;
import eu.tsystems.mms.tic.testframework.utils.ReportUtils;
import java.io.InputStream;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadVisualizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadVisualizer.class);

    public static boolean hasData() {
        return DataStorage.getList().size() > 0;
    }

    public static void generateReport() {
        LOGGER.trace("Generate Report with " + DataStorage.getList().size() + " datasets");
        String tvFolderName = "threadvisualizer";
        String threadVisualizerInputFile = "threads.vm";
        String threadVisualizerOutputFile = "threads.html";
        String css = "threadvisualizer/timeline.css";
        InputStream cssIS = Thread.currentThread().getContextClassLoader().getResourceAsStream("threadvisualizer/timeline.css");
        if (cssIS == null) {
            throw new RuntimeException("threadvisualizer/timeline.css not found");
        }
        String js = "threadvisualizer/timeline.js";
        InputStream jsIS = Thread.currentThread().getContextClassLoader().getResourceAsStream("threadvisualizer/timeline.js");
        if (jsIS == null) {
            throw new RuntimeException("threadvisualizer/timeline.js not found");
        }
        Report report = TesterraListener.getReport();
        ReportUtils.copyFile("threadvisualizer/timeline.css", report.getReportDirectory());
        ReportUtils.copyFile("threadvisualizer/timeline.js", report.getReportDirectory());
        VelocityContext context = new VelocityContext();
        context.put("reportName", (Object)ReportUtils.getReportName());
        StringBuilder sb = new StringBuilder();
        List<DataSet> list = DataStorage.getList();
        for (DataSet dataSet : list) {
            MethodContext methodContext = dataSet.getContext();
            String updatedMethodContent = ThreadVisualizerUtils.getFormattedContent(methodContext);
            String line = "data.addRow([new Date(" + dataSet.getStartTime() + "),new Date(" + dataSet.getStopTime() + "),'" + updatedMethodContent + "','" + methodContext.threadName + "']);";
            sb.append(line).append("\n");
        }
        context.put("data", (Object)sb.toString());
        ReportUtils.addExtraTopLevelTab("threads.vm", "threads.html", "Threads", "threads", context, false);
    }
}

