/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.report.threadvisualizer;

import eu.tsystems.mms.tic.testframework.report.model.context.MethodContext;

public final class ThreadVisualizerUtils {
    private static final String LINEBREAK = "<br/>";

    private ThreadVisualizerUtils() {
    }

    public static String getFormattedContent(MethodContext methodContext) {
        String html = "";
        String style = "background: linear-gradient(to top, " + methodContext.getStatus().color + " 0%, white 100%); ";
        style = methodContext.isConfigMethod() ? style + "border: 2px solid #ffa500; " : style + "border: 1px solid " + methodContext.getStatus().color + "; ";
        style = style + "border-radius: 6px 6px 6px 6px; box-shadow: 0 1px 0 0 #FFFFFF inset; color: #777777; font-family: arial; font-size: 15px; font-weight: bold; padding-left: 2px; padding-top: 2px; padding-bottom: 2px; text-decoration: none; line-height: 15px;";
        html = html + "<div class='tooltip' style='" + style + "'>";
        html = html + "<a onclick='showLoadingIn(null);' href='methods/" + methodContext.methodRunIndex + ".html'>";
        html = html + "<font size='3' color='black'>" + methodContext.getName() + "</font>";
        html = html + LINEBREAK;
        html = html + "<font size='1' color='grey'>" + methodContext.getStatus().title + "</font>";
        html = html + LINEBREAK;
        html = html + "<font size='1' color='white'>" + methodContext.getClassContext().getName() + "</font>";
        html = html + LINEBREAK;
        html = html + "<font size='1' color='white'>(" + methodContext.methodRunIndex + ")</font>";
        html = html + "</a>";
        html = html + "</div>";
        return ThreadVisualizerUtils.formatForHtml(html);
    }

    private static String formatForHtml(String s) {
        return s.replaceAll("'", "\\\\'");
    }
}

