/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.utils;

import eu.tsystems.mms.tic.testframework.info.ReportInfo;
import eu.tsystems.mms.tic.testframework.internal.Flags;
import eu.tsystems.mms.tic.testframework.internal.TimingInfo;
import eu.tsystems.mms.tic.testframework.monitor.JVMMonitor;
import eu.tsystems.mms.tic.testframework.report.FailureCorridor;
import eu.tsystems.mms.tic.testframework.report.ReportingData;
import eu.tsystems.mms.tic.testframework.report.TestStatusController;
import eu.tsystems.mms.tic.testframework.report.TesterraListener;
import eu.tsystems.mms.tic.testframework.report.model.context.ClassContext;
import eu.tsystems.mms.tic.testframework.report.model.context.LogMessage;
import eu.tsystems.mms.tic.testframework.report.model.context.MethodContext;
import eu.tsystems.mms.tic.testframework.report.utils.ExecutionContextController;
import eu.tsystems.mms.tic.testframework.report.velocity.PublicFieldUberspect;
import eu.tsystems.mms.tic.testframework.utils.FilterUtils;
import eu.tsystems.mms.tic.testframework.utils.ReportUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.DateTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportFormatter.class);

    private static void pInit() {
        Properties velocityConfiguration = new Properties();
        velocityConfiguration.setProperty("resource.loader", "class");
        velocityConfiguration.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        velocityConfiguration.setProperty("runtime.log", "target/velocity.log");
        velocityConfiguration.setProperty("runtime.introspector.uberspect", PublicFieldUberspect.class.getName());
        Velocity.init((Properties)velocityConfiguration);
    }

    public static void createTestClassesView(File logFile, ReportingData reportingData, String template, Collection<LogMessage> unrelatedLogs, ReportInfo.RunInfo runInfo) {
        try {
            ReportFormatter.pCreateTestClassesView(logFile, reportingData, template, unrelatedLogs, runInfo);
        }
        catch (IOException e) {
            ReportFormatter.out(e);
        }
    }

    public static void createDashboardHtml(ReportingData reportingData, File logfile, String template) {
        try {
            ReportFormatter.pFormatWithFailuresAndHistory(reportingData, logfile, template);
        }
        catch (IOException e) {
            ReportFormatter.out(e);
        }
    }

    public static void createEmailableReportHtml(ReportingData reportingData, File logFile, String template) {
        Template htmlLogTemplate = Velocity.getTemplate((String)template, (String)"UTF-8");
        htmlLogTemplate.setEncoding("UTF-8");
        VelocityContext context = ReportFormatter.getVelocityContext();
        context.put("failureCorridorMatched", (Object)reportingData.failureCorridorMatched);
        context.put("dashboardInfos", (Object)ReportInfo.getDashboardInfo().getInfos());
        context.put("dashboardWarnings", (Object)ReportInfo.getDashboardWarning().getInfos());
        try {
            ReportFormatter.writeHtml(logFile, htmlLogTemplate, context);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createTimingsHtml(File logFile, Map<String, Long> minPerActions, Map<String, Long> avgPerActions, Map<String, Long> maxPerActions, Map<String, List<TimingInfo>> timingInfosPerAction, String template) {
        try {
            ReportFormatter.pFormatWithMeasurements(logFile, minPerActions, avgPerActions, maxPerActions, timingInfosPerAction, template);
        }
        catch (IOException e) {
            ReportFormatter.out(e);
        }
    }

    public static void createMemoryHtml(File logFile, String template) {
        try {
            ReportFormatter.pFormatWithMemory(logFile, template);
        }
        catch (IOException e) {
            ReportFormatter.out(e);
        }
    }

    private static void pCreateTestClassesView(File logFile, ReportingData reportingData, String template, Collection<LogMessage> unrelatedLogs, ReportInfo.RunInfo runInfo) throws IOException {
        Template htmlLogTemplate = Velocity.getTemplate((String)template, (String)"UTF-8");
        htmlLogTemplate.setEncoding("UTF-8");
        VelocityContext context = ReportFormatter.getVelocityContext();
        context.put("runInfo", (Object)runInfo);
        context.put("reportingData", (Object)reportingData);
        if (reportingData != null) {
            context.put("testClassList", reportingData.classContexts);
        }
        if (unrelatedLogs != null) {
            context.put("unrelatedLogMessages", unrelatedLogs);
        }
        BufferedWriter logWriter = null;
        logWriter = new BufferedWriter(new FileWriter(logFile));
        htmlLogTemplate.merge((Context)context, (Writer)logWriter);
        ((Writer)logWriter).flush();
        ((Writer)logWriter).close();
    }

    public static void createMetricsHtml(File logFile, Object metrics, String template) {
        try {
            ReportFormatter.pFormatWithMetrics(logFile, metrics, template);
        }
        catch (IOException e) {
            ReportFormatter.out(e);
        }
    }

    private static void pFormatWithMetrics(File logFile, Object metrics, String template) throws IOException {
        Template htmlLogTemplate = Velocity.getTemplate((String)template, (String)"UTF-8");
        htmlLogTemplate.setEncoding("UTF-8");
        VelocityContext context = ReportFormatter.getVelocityContext();
        context.put("metrics", metrics);
        BufferedWriter logWriter = null;
        logWriter = new BufferedWriter(new FileWriter(logFile));
        htmlLogTemplate.merge((Context)context, (Writer)logWriter);
        ((Writer)logWriter).flush();
        ((Writer)logWriter).close();
    }

    public static void createMethodsView(File logFile, ClassContext testClass, String template) {
        try {
            ReportFormatter.pFormatWithTestClass(logFile, testClass, template);
        }
        catch (Exception e) {
            ReportFormatter.out(e);
        }
    }

    private static void out(Exception e) {
        LOGGER.error("Could not create html: " + e, (Throwable)e);
    }

    public static void createMethodsFrame(File logFile, MethodContext methodContext, String template) {
        try {
            ReportFormatter.pFormatWithTestMethod(logFile, methodContext, template);
        }
        catch (Exception e) {
            ReportFormatter.out(e);
        }
    }

    public static void createMultiMethodsHtml(ReportingData reportingData, File logFile, String template) {
        try {
            ReportFormatter.pFormatWithFailuresAndHistory(reportingData, logFile, template);
        }
        catch (IOException e) {
            ReportFormatter.out(e);
        }
    }

    private static void pFormatWithTestClass(File logFile, ClassContext testClass, String template) throws IOException {
        Template htmlLogTemplate = Velocity.getTemplate((String)template, (String)"UTF-8");
        htmlLogTemplate.setEncoding("UTF-8");
        VelocityContext context = ReportFormatter.getVelocityContext();
        if (testClass != null) {
            context.put("testClass", (Object)testClass);
        }
        context.put("reportScreenshotsPreview", (Object)Flags.REPORT_SCREENSHOTS_PREVIEW);
        ReportFormatter.writeHtml(logFile, htmlLogTemplate, context);
    }

    private static void pFormatWithTestMethod(File logFile, MethodContext methodContext, String template) throws IOException {
        Template htmlLogTemplate = Velocity.getTemplate((String)template, (String)"UTF-8");
        htmlLogTemplate.setEncoding("UTF-8");
        VelocityContext context = ReportFormatter.getVelocityContext();
        context.put("testMethod", (Object)methodContext);
        ReportFormatter.writeHtml(logFile, htmlLogTemplate, context);
    }

    static void createHtml(String vmTemplateFileInResources, File htmlOutputFile, VelocityContext velocityContext) throws IOException {
        Object[] keys;
        VelocityContext baseContext = ReportFormatter.getVelocityContext();
        for (Object key : keys = baseContext.getKeys()) {
            String stringKey;
            if (!(key instanceof String) || velocityContext.containsKey((Object)(stringKey = (String)key))) continue;
            velocityContext.put(stringKey, baseContext.get(stringKey));
        }
        Template htmlLogTemplate = Velocity.getTemplate((String)vmTemplateFileInResources, (String)"UTF-8");
        ReportFormatter.writeHtml(htmlOutputFile, htmlLogTemplate, velocityContext);
    }

    private static void pFormatWithMeasurements(File logFile, Map<String, Long> minPerActions, Map<String, Long> avgPerActions, Map<String, Long> maxPerActions, Map<String, List<TimingInfo>> timingInfosPerAction, String template) throws IOException {
        Template htmlLogTemplate = Velocity.getTemplate((String)template, (String)"UTF-8");
        htmlLogTemplate.setEncoding("UTF-8");
        VelocityContext context = ReportFormatter.getVelocityContext();
        context.put("tabId", (Object)"Timings");
        context.put("tabName", (Object)"Timings");
        context.put("allActions", timingInfosPerAction);
        context.put("avgPerActions", avgPerActions);
        context.put("minPerActions", minPerActions);
        context.put("maxPerActions", maxPerActions);
        ReportFormatter.writeHtml(logFile, htmlLogTemplate, context);
    }

    private static void pFormatWithMemory(File logFile, String template) throws IOException {
        Template htmlLogTemplate = Velocity.getTemplate((String)template, (String)"UTF-8");
        htmlLogTemplate.setEncoding("UTF-8");
        VelocityContext context = ReportFormatter.getVelocityContext();
        context.put("memory", (Object)JVMMonitor.getMeasurements());
        context.put("memoryTotal", (Object)JVMMonitor.getMeasurementsTotal());
        context.put("labels", (Object)JVMMonitor.getLabels());
        context.put("memoryMax", (Object)JVMMonitor.getMaxMemory());
        ReportFormatter.writeHtml(logFile, htmlLogTemplate, context);
    }

    private static void pFormatWithFailuresAndHistory(ReportingData reportingData, File logFile, String template) throws IOException {
        Template htmlLogTemplate = Velocity.getTemplate((String)template, (String)"UTF-8");
        htmlLogTemplate.setEncoding("UTF-8");
        VelocityContext context = ReportFormatter.getVelocityContext();
        context.put("reportingData", (Object)reportingData);
        context.put("classContexts", reportingData.classContexts);
        context.put("dashboardInfos", (Object)ReportInfo.getDashboardInfo().getInfos());
        context.put("dashboardWarnings", (Object)ReportInfo.getDashboardWarning().getInfos());
        ReportFormatter.writeHtml(logFile, htmlLogTemplate, context);
    }

    private static VelocityContext getVelocityContext() {
        TestStatusController.Status[] values;
        VelocityContext context = new VelocityContext();
        context.put("executionContext", (Object)ExecutionContextController.getCurrentExecutionContext());
        context.put("TesterraBuildInformation", (Object)TesterraListener.getBuildInformation());
        context.put("reportScreenshotsPreview", (Object)Flags.REPORT_SCREENSHOTS_PREVIEW);
        context.put("reportName", (Object)ReportUtils.getReportName());
        context.put("dryrun", (Object)Flags.DRY_RUN);
        context.put("dateFormatter", (Object)new DateTool());
        context.put("filter", (Object)FilterUtils.getInstance());
        context.put("fcActive", (Object)Flags.FAILURE_CORRIDOR_ACTIVE);
        context.put("fcMatched", (Object)FailureCorridor.isCorridorMatched());
        context.put("fcH", (Object)TestStatusController.getTestsFailedHIGH());
        context.put("fcM", (Object)TestStatusController.getTestsFailedMID());
        context.put("fcL", (Object)TestStatusController.getTestsFailedLOW());
        context.put("fcHAllowed", (Object)FailureCorridor.getAllowedTestFailuresHIGH());
        context.put("fcMAllowed", (Object)FailureCorridor.getAllowedTestFailuresMID());
        context.put("fcLAllowed", (Object)FailureCorridor.getAllowedTestFailuresLOW());
        context.put("fcExpectedFailed", (Object)TestStatusController.getTestsExpectedFailed());
        context.put("fcFailedRetried", (Object)TestStatusController.getTestsFailedRetried());
        context.put("fcFailed", (Object)TestStatusController.getTestsFailed());
        context.put("fcAllFailed", (Object)TestStatusController.getAllFailed());
        context.put("topLevelTabs", ReportUtils.TOP_LEVEL_TABS);
        for (TestStatusController.Status value : values = TestStatusController.Status.values()) {
            context.put("status_" + value.name(), (Object)value);
        }
        return context;
    }

    private static void writeHtml(File htmlOutputFile, Template htmlLogTemplate, VelocityContext context) throws IOException {
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(htmlOutputFile));
        htmlLogTemplate.merge((Context)context, (Writer)logWriter);
        ((Writer)logWriter).flush();
        ((Writer)logWriter).close();
    }

    static {
        ReportFormatter.pInit();
    }
}

