/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.ide;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.thestencil.quarkus.ide.FrontendBeanFactory;
import io.thestencil.quarkus.ide.FrontendConfig;
import io.thestencil.quarkus.ide.FrontendRecorder;
import io.thestencil.quarkus.ide.HdesUIBuildItem;
import io.thestencil.quarkus.ide.IndexFactory;
import io.vertx.core.Handler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Hex;

public class FrontendProcessor {
    private static final String WEBJAR_GROUP_ID = "io.thestencil";
    private static final String WEBJAR_ARTIFACT_ID = "stencil-composer-integration";
    private static final String WEBJAR_PREFIX = "META-INF/resources/webjars/stencil-composer-integration/";
    private static final String FINAL_DESTINATION = "META-INF/portal-files";
    public static final String FEATURE_BUILD_ITEM = "stencil-composer";
    @Inject
    private LaunchModeBuildItem launch;
    FrontendConfig config;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE_BUILD_ITEM);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void backendBeans(FrontendRecorder recorder, BuildProducer<AdditionalBeanBuildItem> buildItems, BuildProducer<BeanContainerListenerBuildItem> beans) {
        buildItems.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(FrontendBeanFactory.class).build());
        beans.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.listener()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void frontendHandler(FrontendRecorder recorder, HttpRootPathBuildItem httpRoot, BuildProducer<RouteBuildItem> routes, HdesUIBuildItem buildItem, FrontendConfig uiConfig, BodyHandlerBuildItem body) throws Exception {
        Handler handler = recorder.uiHandler(buildItem.getUiFinalDestination(), buildItem.getUiPath(), buildItem.getHash());
        routes.produce((BuildItem)httpRoot.routeBuilder().route(uiConfig.servicePath).handler(handler).build());
        routes.produce((BuildItem)httpRoot.routeBuilder().route(uiConfig.servicePath + "/*").handler(handler).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void frontendBeans(FrontendRecorder recorder, BuildProducer<HdesUIBuildItem> buildProducer, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImage, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LiveReloadBuildItem liveReloadBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        String hash = Hex.encodeHexString((byte[])LocalDateTime.now().toString().getBytes(StandardCharsets.UTF_8), (boolean)true);
        AppArtifact artifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)WEBJAR_GROUP_ID, (String)WEBJAR_ARTIFACT_ID);
        if (this.launch.getLaunchMode().isDevOrTest()) {
            Path tempPath = WebJarUtil.copyResourcesForDevOrTest((LiveReloadBuildItem)liveReloadBuildItem, (CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)this.launch, (AppArtifact)artifact, (String)(WEBJAR_PREFIX + artifact.getVersion()), (boolean)false);
            Path index = tempPath.resolve("index.html");
            String frontendPath = httpRootPathBuildItem.resolvePath(this.config.servicePath);
            WebJarUtil.updateFile((Path)index, (byte[])IndexFactory.builder().frontend(frontendPath).server(httpRootPathBuildItem.resolvePath(this.config.serverPath)).index(index).build());
            buildProducer.produce((BuildItem)new HdesUIBuildItem(tempPath.toAbsolutePath().toString(), frontendPath, hash));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(frontendPath + "/"), "Zoe IDE"));
            if (liveReloadBuildItem.isLiveReload() && !liveReloadBuildItem.getChangedResources().isEmpty()) {
                WebJarUtil.hotReloadBrandingChanges((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)this.launch, (AppArtifact)artifact, (Set)liveReloadBuildItem.getChangedResources());
            }
        } else {
            String frontendPath = httpRootPathBuildItem.resolvePath(this.config.servicePath);
            Map files = WebJarUtil.copyResourcesForProduction((CurateOutcomeBuildItem)curateOutcomeBuildItem, (AppArtifact)artifact, (String)(WEBJAR_PREFIX + artifact.getVersion()));
            boolean indexReplaced = false;
            for (Map.Entry file : files.entrySet()) {
                byte[] content;
                Object fileName = (String)file.getKey();
                if (((String)fileName).endsWith("index.html")) {
                    content = IndexFactory.builder().frontend(frontendPath).server(this.config.serverPath).index((byte[])file.getValue()).build();
                    indexReplaced = true;
                } else {
                    content = (byte[])file.getValue();
                }
                fileName = "META-INF/portal-files/" + (String)fileName;
                generatedResources.produce((BuildItem)new GeneratedResourceBuildItem((String)fileName, content));
                nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
            }
            if (!indexReplaced) {
                throw new ConfigurationError("Failed to create stencil-ide index.html, " + "artifact = " + artifact + System.lineSeparator() + "," + "path = " + frontendPath + "!" + "final destination = " + FINAL_DESTINATION + "!");
            }
            buildProducer.produce((BuildItem)new HdesUIBuildItem(FINAL_DESTINATION, frontendPath, hash));
        }
    }
}

