/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.ide;

import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.util.FileUtil;
import io.thestencil.quarkus.ide.PortalAssert;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;

public class IndexFactory {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String frontendPath;
        private String server;
        private String indexFileContent;

        public Builder frontend(String frontendPath) {
            this.frontendPath = frontendPath;
            return this;
        }

        public Builder server(String backendPath) {
            this.server = backendPath;
            return this;
        }

        public Builder index(Path path) {
            File file = path.toFile();
            try (FileInputStream stream = new FileInputStream(file);){
                byte[] bytes = FileUtil.readFileContents((InputStream)stream);
                this.indexFileContent = new String(bytes, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new ConfigurationError("Failed to create frontend index.html, " + "msg = " + e.getMessage() + System.lineSeparator() + "," + "path = " + path + "!");
            }
            return this;
        }

        public Builder index(byte[] indexFileContent) {
            this.indexFileContent = new String(indexFileContent, StandardCharsets.UTF_8);
            return this;
        }

        public byte[] build() {
            PortalAssert.notEmpty(this.frontendPath, () -> "define frontendPath!");
            PortalAssert.notEmpty(this.server, () -> "define server!");
            Object newPath = this.frontendPath.startsWith("/") ? this.frontendPath : "/" + this.frontendPath;
            newPath = ((String)newPath).endsWith("/") ? newPath : (String)newPath + "/";
            StringBuilder newHref = new StringBuilder().append((String)newPath);
            StringBuilder newConfig = new StringBuilder().append("const portalconfig={").append("server: { url: '" + this.server + "', buildTime: '" + LocalDateTime.now() + "' }, ").append("}");
            return (this.indexFileContent.replaceAll("/portal/", (String)newPath).replaceAll("https://portalconfig/", newHref.toString()).replaceFirst("const portalconfig=\\{\\}", newConfig.toString()) + "<!-- NEW - PATH: " + (String)newPath + "-->").getBytes(StandardCharsets.UTF_8);
        }
    }
}

