/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.DocDB;
import io.thestencil.client.spi.PersistenceConfig;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PersistenceConfig", generator="Immutables")
@Immutable
public final class ImmutablePersistenceConfig
implements PersistenceConfig {
    private final DocDB client;
    private final String repoName;
    private final String headName;
    private final PersistenceConfig.AuthorProvider authorProvider;
    private final PersistenceConfig.Serializer serializer;
    private final PersistenceConfig.Deserializer deserializer;
    private final PersistenceConfig.GidProvider gidProvider;

    private ImmutablePersistenceConfig(DocDB client, String repoName, String headName, PersistenceConfig.AuthorProvider authorProvider, PersistenceConfig.Serializer serializer, PersistenceConfig.Deserializer deserializer, PersistenceConfig.GidProvider gidProvider) {
        this.client = client;
        this.repoName = repoName;
        this.headName = headName;
        this.authorProvider = authorProvider;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.gidProvider = gidProvider;
    }

    @Override
    public DocDB getClient() {
        return this.client;
    }

    @Override
    public String getRepoName() {
        return this.repoName;
    }

    @Override
    public String getHeadName() {
        return this.headName;
    }

    @Override
    public PersistenceConfig.AuthorProvider getAuthorProvider() {
        return this.authorProvider;
    }

    @Override
    public PersistenceConfig.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public PersistenceConfig.Deserializer getDeserializer() {
        return this.deserializer;
    }

    @Override
    public PersistenceConfig.GidProvider getGidProvider() {
        return this.gidProvider;
    }

    public final ImmutablePersistenceConfig withClient(DocDB value) {
        if (this.client == value) {
            return this;
        }
        DocDB newValue = Objects.requireNonNull(value, "client");
        return new ImmutablePersistenceConfig(newValue, this.repoName, this.headName, this.authorProvider, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutablePersistenceConfig withRepoName(String value) {
        String newValue = Objects.requireNonNull(value, "repoName");
        if (this.repoName.equals(newValue)) {
            return this;
        }
        return new ImmutablePersistenceConfig(this.client, newValue, this.headName, this.authorProvider, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutablePersistenceConfig withHeadName(String value) {
        String newValue = Objects.requireNonNull(value, "headName");
        if (this.headName.equals(newValue)) {
            return this;
        }
        return new ImmutablePersistenceConfig(this.client, this.repoName, newValue, this.authorProvider, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutablePersistenceConfig withAuthorProvider(PersistenceConfig.AuthorProvider value) {
        if (this.authorProvider == value) {
            return this;
        }
        PersistenceConfig.AuthorProvider newValue = Objects.requireNonNull(value, "authorProvider");
        return new ImmutablePersistenceConfig(this.client, this.repoName, this.headName, newValue, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutablePersistenceConfig withSerializer(PersistenceConfig.Serializer value) {
        if (this.serializer == value) {
            return this;
        }
        PersistenceConfig.Serializer newValue = Objects.requireNonNull(value, "serializer");
        return new ImmutablePersistenceConfig(this.client, this.repoName, this.headName, this.authorProvider, newValue, this.deserializer, this.gidProvider);
    }

    public final ImmutablePersistenceConfig withDeserializer(PersistenceConfig.Deserializer value) {
        if (this.deserializer == value) {
            return this;
        }
        PersistenceConfig.Deserializer newValue = Objects.requireNonNull(value, "deserializer");
        return new ImmutablePersistenceConfig(this.client, this.repoName, this.headName, this.authorProvider, this.serializer, newValue, this.gidProvider);
    }

    public final ImmutablePersistenceConfig withGidProvider(PersistenceConfig.GidProvider value) {
        if (this.gidProvider == value) {
            return this;
        }
        PersistenceConfig.GidProvider newValue = Objects.requireNonNull(value, "gidProvider");
        return new ImmutablePersistenceConfig(this.client, this.repoName, this.headName, this.authorProvider, this.serializer, this.deserializer, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePersistenceConfig && this.equalTo((ImmutablePersistenceConfig)another);
    }

    private boolean equalTo(ImmutablePersistenceConfig another) {
        return this.client.equals(another.client) && this.repoName.equals(another.repoName) && this.headName.equals(another.headName) && this.authorProvider.equals(another.authorProvider) && this.serializer.equals(another.serializer) && this.deserializer.equals(another.deserializer) && this.gidProvider.equals(another.gidProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.repoName.hashCode();
        h += (h << 5) + this.headName.hashCode();
        h += (h << 5) + this.authorProvider.hashCode();
        h += (h << 5) + this.serializer.hashCode();
        h += (h << 5) + this.deserializer.hashCode();
        h += (h << 5) + this.gidProvider.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PersistenceConfig").omitNullValues().add("client", (Object)this.client).add("repoName", (Object)this.repoName).add("headName", (Object)this.headName).add("authorProvider", (Object)this.authorProvider).add("serializer", (Object)this.serializer).add("deserializer", (Object)this.deserializer).add("gidProvider", (Object)this.gidProvider).toString();
    }

    public static ImmutablePersistenceConfig copyOf(PersistenceConfig instance) {
        if (instance instanceof ImmutablePersistenceConfig) {
            return (ImmutablePersistenceConfig)instance;
        }
        return ImmutablePersistenceConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PersistenceConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT = 1L;
        private static final long INIT_BIT_REPO_NAME = 2L;
        private static final long INIT_BIT_HEAD_NAME = 4L;
        private static final long INIT_BIT_AUTHOR_PROVIDER = 8L;
        private static final long INIT_BIT_SERIALIZER = 16L;
        private static final long INIT_BIT_DESERIALIZER = 32L;
        private static final long INIT_BIT_GID_PROVIDER = 64L;
        private long initBits = 127L;
        @Nullable
        private DocDB client;
        @Nullable
        private String repoName;
        @Nullable
        private String headName;
        @Nullable
        private PersistenceConfig.AuthorProvider authorProvider;
        @Nullable
        private PersistenceConfig.Serializer serializer;
        @Nullable
        private PersistenceConfig.Deserializer deserializer;
        @Nullable
        private PersistenceConfig.GidProvider gidProvider;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PersistenceConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.client(instance.getClient());
            this.repoName(instance.getRepoName());
            this.headName(instance.getHeadName());
            this.authorProvider(instance.getAuthorProvider());
            this.serializer(instance.getSerializer());
            this.deserializer(instance.getDeserializer());
            this.gidProvider(instance.getGidProvider());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(DocDB client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repoName(String repoName) {
            this.repoName = Objects.requireNonNull(repoName, "repoName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headName(String headName) {
            this.headName = Objects.requireNonNull(headName, "headName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authorProvider(PersistenceConfig.AuthorProvider authorProvider) {
            this.authorProvider = Objects.requireNonNull(authorProvider, "authorProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serializer(PersistenceConfig.Serializer serializer) {
            this.serializer = Objects.requireNonNull(serializer, "serializer");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deserializer(PersistenceConfig.Deserializer deserializer) {
            this.deserializer = Objects.requireNonNull(deserializer, "deserializer");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gidProvider(PersistenceConfig.GidProvider gidProvider) {
            this.gidProvider = Objects.requireNonNull(gidProvider, "gidProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutablePersistenceConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePersistenceConfig(this.client, this.repoName, this.headName, this.authorProvider, this.serializer, this.deserializer, this.gidProvider);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repoName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("headName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("authorProvider");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("serializer");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("deserializer");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("gidProvider");
            }
            return "Cannot build PersistenceConfig, some of required attributes are not set " + attributes;
        }
    }
}

