/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.actions.RepoActions;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.CreateBuilder;
import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableLocale;
import io.thestencil.client.api.ImmutableLocaleLabel;
import io.thestencil.client.api.ImmutablePage;
import io.thestencil.client.api.ImmutableRelease;
import io.thestencil.client.api.ImmutableSiteState;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceConfig;
import io.thestencil.client.spi.builders.CreateReleaseVisitor;
import io.thestencil.client.spi.builders.QueryBuilderImpl;
import io.thestencil.client.spi.exceptions.ConstraintException;
import io.thestencil.client.spi.exceptions.RefException;
import io.thestencil.client.spi.exceptions.RepoException;
import io.thestencil.client.spi.exceptions.SaveException;
import java.util.Optional;

public class CreateBuilderImpl
implements CreateBuilder {
    private final PersistenceConfig config;

    public CreateBuilderImpl(PersistenceConfig config) {
        this.config = config;
    }

    public Uni<StencilClient.Entity<StencilClient.Article>> article(CreateBuilder.CreateArticle init) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> {
            String gid = this.gid(StencilClient.EntityType.ARTICLE);
            ImmutableArticle article = ImmutableArticle.builder().name(init.getName()).parentId(init.getParentId()).order(Optional.ofNullable(init.getOrder()).orElse(0)).build();
            ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.ARTICLE).body((StencilClient.EntityBody)article).build();
            Optional<StencilClient.Entity> duplicate = state.getArticles().values().stream().filter(p -> ((StencilClient.Article)p.getBody()).getName().equals(init.getName())).findFirst();
            if (duplicate.isPresent()) {
                throw new ConstraintException((StencilClient.Entity<?>)entity, "Article: '" + init.getName() + "' already exists!");
            }
            return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("creating-article").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(gid, this.config.getSerializer().toString((StencilClient.Entity<?>)entity)).build().onItem().transform(arg_0 -> CreateBuilderImpl.lambda$article$1((StencilClient.Entity)entity, arg_0));
        });
    }

    public Uni<StencilClient.Entity<StencilClient.Release>> release(CreateBuilder.CreateRelease init) {
        return this.config.getClient().objects().refState().repo(this.config.getRepoName()).ref(this.config.getHeadName()).blobs(true).build().onItem().transformToUni(state -> {
            if (state.getStatus() == ObjectsActions.ObjectsStatus.OK) {
                String gid = this.gid(StencilClient.EntityType.RELEASE);
                ImmutableRelease release = new CreateReleaseVisitor((ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>)state, this.config).visit(ImmutableRelease.builder().name(init.getName()).note(Optional.ofNullable(init.getNote()).orElse("")).parentCommit(((ObjectsActions.RefObjects)state.getObjects()).getRef().getCommit())).build();
                ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.RELEASE).body((StencilClient.EntityBody)release).build();
                return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("creating-release").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(gid, this.config.getSerializer().toString((StencilClient.Entity<?>)entity)).build().onItem().transform(arg_0 -> CreateBuilderImpl.lambda$release$3((StencilClient.Entity)entity, arg_0));
            }
            throw new RefException("Can't create release because ref state query failed!", (ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>)state);
        });
    }

    public Uni<StencilClient.Entity<StencilClient.Locale>> locale(CreateBuilder.CreateLocale init) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> {
            String gid = this.gid(StencilClient.EntityType.LOCALE);
            ImmutableLocale locale = ImmutableLocale.builder().value(init.getLocale()).enabled(Boolean.valueOf(true)).build();
            ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LOCALE).body((StencilClient.EntityBody)locale).build();
            Optional<StencilClient.Entity> duplicate = state.getLocales().values().stream().filter(p -> ((StencilClient.Locale)p.getBody()).getValue().equals(init.getLocale())).findFirst();
            if (duplicate.isPresent()) {
                throw new ConstraintException((StencilClient.Entity<?>)entity, "Locale: '" + init.getLocale() + "' already exists!");
            }
            return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("creating-locale").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(gid, this.config.getSerializer().toString((StencilClient.Entity<?>)entity)).build().onItem().transform(arg_0 -> CreateBuilderImpl.lambda$locale$6((StencilClient.Entity)entity, arg_0));
        });
    }

    public Uni<StencilClient.Entity<StencilClient.Page>> page(CreateBuilder.CreatePage init) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> {
            String localeId = init.getLocale();
            String gid = this.gid(StencilClient.EntityType.PAGE);
            ImmutablePage page = ImmutablePage.builder().article(init.getArticleId()).locale(localeId).content(Optional.ofNullable(init.getContent()).orElse("")).build();
            ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.PAGE).body((StencilClient.EntityBody)page).build();
            if (!state.getLocales().containsKey(localeId)) {
                throw new ConstraintException((StencilClient.Entity<?>)entity, "Locale with id: '" + localeId + "' does not exist in: '" + String.join((CharSequence)",", state.getLocales().keySet()) + "'!");
            }
            Optional<StencilClient.Entity> duplicate = state.getPages().values().stream().filter(p -> ((StencilClient.Page)p.getBody()).getArticle().equals(init.getArticleId())).filter(p -> ((StencilClient.Page)p.getBody()).getLocale().equals(init.getLocale())).findFirst();
            if (duplicate.isPresent()) {
                throw new ConstraintException((StencilClient.Entity<?>)entity, "Page locale with id: '" + localeId + "' already exists!");
            }
            return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("creating-page").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(gid, this.config.getSerializer().toString((StencilClient.Entity<?>)entity)).build().onItem().transform(arg_0 -> CreateBuilderImpl.lambda$page$10((StencilClient.Entity)entity, arg_0));
        });
    }

    public Uni<StencilClient.Entity<StencilClient.Link>> link(CreateBuilder.CreateLink init) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> {
            String gid = this.gid(StencilClient.EntityType.LINK);
            ImmutableLink.Builder link = ImmutableLink.builder().contentType(init.getType()).value(init.getValue()).articles((Iterable)init.getArticles());
            for (StencilClient.LocaleLabel label : init.getLabels()) {
                link.addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().locale(label.getLocale()).labelValue(label.getLabelValue()).build());
                if (state.getLocales().containsKey(label.getLocale())) continue;
                throw new ConstraintException((StencilClient.Entity<?>)ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LINK).body((StencilClient.EntityBody)link.build()).build(), "Locale with id: '" + label.getLocale() + "' does not exist in: '" + String.join((CharSequence)",", state.getLocales().keySet()) + "'!");
            }
            ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LINK).body((StencilClient.EntityBody)link.build()).build();
            return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("creating-link").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(gid, this.config.getSerializer().toString((StencilClient.Entity<?>)entity)).build().onItem().transform(commit -> {
                if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                    return entity;
                }
                throw new SaveException((StencilClient.Entity<?>)entity, (CommitActions.CommitResult)commit);
            });
        });
    }

    public Uni<StencilClient.Entity<StencilClient.Workflow>> workflow(CreateBuilder.CreateWorkflow init) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> {
            String gid = this.gid(StencilClient.EntityType.WORKFLOW);
            ImmutableWorkflow.Builder workflow = ImmutableWorkflow.builder().devMode(init.getDevMode()).value(init.getValue()).articles((Iterable)init.getArticles());
            for (StencilClient.LocaleLabel label : init.getLabels()) {
                workflow.addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().locale(label.getLocale()).labelValue(label.getLabelValue()).build());
                if (state.getLocales().containsKey(label.getLocale())) continue;
                throw new ConstraintException((StencilClient.Entity<?>)ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.WORKFLOW).body((StencilClient.EntityBody)workflow.build()).build(), "Locale with id: '" + label.getLocale() + "' does not exist in: '" + String.join((CharSequence)",", state.getLocales().keySet()) + "'!");
            }
            ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.WORKFLOW).body((StencilClient.EntityBody)workflow.build()).build();
            return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("creating-workflow").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(gid, this.config.getSerializer().toString((StencilClient.Entity<?>)entity)).build().onItem().transform(commit -> {
                if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                    return entity;
                }
                throw new SaveException((StencilClient.Entity<?>)entity, (CommitActions.CommitResult)commit);
            });
        });
    }

    private String gid(StencilClient.EntityType type) {
        return this.config.getGidProvider().getNextId(type);
    }

    public Uni<StencilClient.SiteState> repo() {
        return this.config.getClient().repo().create().name(this.config.getRepoName()).build().onItem().transform(repoResult -> {
            if (repoResult.getStatus() == RepoActions.RepoStatus.OK) {
                return ImmutableSiteState.builder().contentType(StencilClient.SiteContentType.OK).name(repoResult.getRepo().getName()).build();
            }
            throw new RepoException("Can't create repository with name: '" + this.config.getRepoName() + "'!", (RepoActions.RepoResult)repoResult);
        });
    }

    private static /* synthetic */ StencilClient.Entity lambda$page$10(StencilClient.Entity entity, CommitActions.CommitResult commit) {
        if (commit.getStatus() == CommitActions.CommitStatus.OK) {
            return entity;
        }
        throw new SaveException(entity, commit);
    }

    private static /* synthetic */ StencilClient.Entity lambda$locale$6(StencilClient.Entity entity, CommitActions.CommitResult commit) {
        if (commit.getStatus() == CommitActions.CommitStatus.OK) {
            return entity;
        }
        throw new SaveException(entity, commit);
    }

    private static /* synthetic */ StencilClient.Entity lambda$release$3(StencilClient.Entity entity, CommitActions.CommitResult commit) {
        if (commit.getStatus() == CommitActions.CommitStatus.OK) {
            return entity;
        }
        throw new SaveException(entity, commit);
    }

    private static /* synthetic */ StencilClient.Entity lambda$article$1(StencilClient.Entity entity, CommitActions.CommitResult commit) {
        if (commit.getStatus() == CommitActions.CommitStatus.OK) {
            return entity;
        }
        throw new SaveException(entity, commit);
    }
}

