/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.api.actions.CommitActions;
import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableLocale;
import io.thestencil.client.api.ImmutableLocaleLabel;
import io.thestencil.client.api.ImmutablePage;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MigrationImportVisitor {
    private final PersistenceConfig config;
    private final CommitActions.HeadCommitBuilder commit;
    private final Map<String, StencilClient.Entity<StencilClient.Article>> articlesByTopicId = new HashMap<String, StencilClient.Entity<StencilClient.Article>>();
    private final Map<String, StencilClient.Entity<StencilClient.Link>> links = new HashMap<String, StencilClient.Entity<StencilClient.Link>>();
    private final Map<String, StencilClient.Entity<StencilClient.Workflow>> workflows = new HashMap<String, StencilClient.Entity<StencilClient.Workflow>>();
    private final StencilClient.SiteState current;
    private final List<String> commitedIds = new ArrayList<String>();

    public MigrationImportVisitor(PersistenceConfig config, StencilClient.SiteState current) {
        this.config = config;
        this.current = current;
        this.commit = this.config.getClient().commit().head();
    }

    public CommitActions.HeadCommitBuilder visit(MigrationBuilder.Sites sites) {
        for (MigrationBuilder.LocalizedSite localizedSite : sites.getSites().values()) {
            StencilClient.Entity<StencilClient.Locale> locale = this.visitLocale(localizedSite);
            for (MigrationBuilder.Topic topic : localizedSite.getTopics().values()) {
                StencilClient.Entity<StencilClient.Article> article = this.visitArticle(locale, topic, localizedSite);
                this.visitPage(article, locale, (MigrationBuilder.TopicBlob)localizedSite.getBlobs().get(topic.getBlob()));
                for (String topicLinkId : topic.getLinks()) {
                    MigrationBuilder.TopicLink topicLink = (MigrationBuilder.TopicLink)localizedSite.getLinks().get(topicLinkId);
                    if (topicLink.getType().equalsIgnoreCase("workflow") || topicLink.getType().equalsIgnoreCase("dialob")) {
                        this.visitWorkflow(topicLink, locale, article);
                        continue;
                    }
                    this.visitLink(topicLink, locale, article);
                }
            }
        }
        for (StencilClient.Entity entity : this.links.values()) {
            this.visitCommit(entity);
        }
        for (StencilClient.Entity entity : this.workflows.values()) {
            this.visitCommit(entity);
        }
        this.visitCurrentState(this.current);
        return this.commit;
    }

    private void visitCurrentState(StencilClient.SiteState current) {
        current.getLocales().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.commit.remove(e.getId()));
        current.getPages().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.commit.remove(e.getId()));
        current.getLinks().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.commit.remove(e.getId()));
        current.getArticles().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.commit.remove(e.getId()));
        current.getWorkflows().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.commit.remove(e.getId()));
    }

    private void visitCommit(StencilClient.Entity<?> entity) {
        if (this.commitedIds.contains(entity.getId())) {
            throw new IllegalArgumentException("id already in commit: " + entity.getId());
        }
        this.commitedIds.add(entity.getId());
        this.commit.append(entity.getId(), this.config.getSerializer().toString(entity));
    }

    private StencilClient.Entity<StencilClient.Workflow> visitWorkflow(MigrationBuilder.TopicLink topicLink, StencilClient.Entity<StencilClient.Locale> locale, StencilClient.Entity<StencilClient.Article> article) {
        String topicLinkId = this.topicLinkId(topicLink, locale);
        ArrayList articles = new ArrayList();
        if (this.workflows.containsKey(topicLinkId)) {
            Optional<StencilClient.LocaleLabel> duplicate;
            StencilClient.Entity<StencilClient.Workflow> created = this.workflows.get(topicLinkId);
            articles.addAll(((StencilClient.Workflow)created.getBody()).getArticles());
            if (!articles.contains(article.getId())) {
                articles.add(article.getId());
            }
            if ((duplicate = ((StencilClient.Workflow)created.getBody()).getLabels().stream().filter(label -> label.getLocale().equals(locale.getId())).findFirst()).isEmpty()) {
                ImmutableEntity next = ImmutableEntity.builder().from(created).body((StencilClient.EntityBody)ImmutableWorkflow.builder().from((StencilClient.Workflow)created.getBody()).addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().labelValue(topicLink.getName()).locale(locale.getId()).build()).build()).build();
                this.workflows.put(topicLinkId, (StencilClient.Entity<StencilClient.Workflow>)next);
                return next;
            }
            return created;
        }
        String gid = this.gid(StencilClient.EntityType.WORKFLOW);
        articles.add(article.getId());
        ImmutableWorkflow workflow = ImmutableWorkflow.builder().value(topicLink.getValue()).addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().labelValue(topicLink.getName()).locale(locale.getId()).build()).articles(Boolean.TRUE.equals(topicLink.getGlobal()) ? Collections.emptyList() : articles).build();
        ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.WORKFLOW).body((StencilClient.EntityBody)workflow).build();
        this.workflows.put(topicLinkId, (StencilClient.Entity<StencilClient.Workflow>)entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Link> visitLink(MigrationBuilder.TopicLink topicLink, StencilClient.Entity<StencilClient.Locale> locale, StencilClient.Entity<StencilClient.Article> article) {
        String topicLinkId = this.topicLinkId(topicLink, locale);
        ArrayList articles = new ArrayList();
        if (this.links.containsKey(topicLinkId)) {
            Optional<StencilClient.LocaleLabel> duplicate;
            StencilClient.Entity<StencilClient.Link> created = this.links.get(topicLinkId);
            articles.addAll(((StencilClient.Link)created.getBody()).getArticles());
            if (!articles.contains(article.getId())) {
                articles.add(article.getId());
            }
            if ((duplicate = ((StencilClient.Link)created.getBody()).getLabels().stream().filter(label -> label.getLocale().equals(locale.getId())).findFirst()).isEmpty()) {
                ImmutableEntity next = ImmutableEntity.builder().from(created).body((StencilClient.EntityBody)ImmutableLink.builder().from((StencilClient.Link)created.getBody()).addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().labelValue(topicLink.getName()).locale(locale.getId()).build()).build()).build();
                this.links.put(topicLinkId, (StencilClient.Entity<StencilClient.Link>)next);
                return next;
            }
            return created;
        }
        String gid = this.gid(StencilClient.EntityType.LINK);
        articles.add(article.getId());
        ImmutableLink link = ImmutableLink.builder().contentType(topicLink.getType()).value(topicLink.getValue()).addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().labelValue(topicLink.getName()).locale(locale.getId()).build()).articles(Boolean.TRUE.equals(topicLink.getGlobal()) ? Collections.emptyList() : articles).build();
        ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LINK).body((StencilClient.EntityBody)link).build();
        this.links.put(topicLinkId, (StencilClient.Entity<StencilClient.Link>)entity);
        return entity;
    }

    private String topicLinkId(MigrationBuilder.TopicLink topicLink, StencilClient.Entity<StencilClient.Locale> locale) {
        return topicLink.getType() + "::" + topicLink.getValue();
    }

    private StencilClient.Entity<StencilClient.Page> visitPage(StencilClient.Entity<StencilClient.Article> article, StencilClient.Entity<StencilClient.Locale> locale, MigrationBuilder.TopicBlob topic) {
        String gid = this.gid(StencilClient.EntityType.PAGE);
        ImmutablePage page = ImmutablePage.builder().article(article.getId()).locale(locale.getId()).content(Optional.ofNullable(topic.getValue()).orElse("")).build();
        ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.PAGE).body((StencilClient.EntityBody)page).build();
        this.visitCommit((StencilClient.Entity<?>)entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Article> visitArticle(StencilClient.Entity<StencilClient.Locale> locale, MigrationBuilder.Topic topic, MigrationBuilder.LocalizedSite site) {
        String parentId;
        if (this.articlesByTopicId.containsKey(topic.getId())) {
            return this.articlesByTopicId.get(topic.getId());
        }
        String name = null;
        if (topic.getParent() != null && topic.getId().startsWith(topic.getParent())) {
            name = topic.getId().substring(topic.getParent().length() + 1);
            parentId = this.visitArticle(locale, (MigrationBuilder.Topic)site.getTopics().get(topic.getParent()), site).getId();
        } else {
            name = topic.getId();
            parentId = null;
        }
        int order = 0;
        try {
            order = Integer.parseInt(name.substring(0, 3));
            name = name.substring(4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String gid = this.gid(StencilClient.EntityType.ARTICLE);
        ImmutableArticle article = ImmutableArticle.builder().name(name).parentId(parentId).order(Integer.valueOf(order)).build();
        ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.ARTICLE).body((StencilClient.EntityBody)article).build();
        this.articlesByTopicId.put(topic.getId(), (StencilClient.Entity<StencilClient.Article>)entity);
        this.visitCommit((StencilClient.Entity<?>)entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Locale> visitLocale(MigrationBuilder.LocalizedSite site) {
        String gid = this.gid(StencilClient.EntityType.LOCALE);
        ImmutableLocale locale = ImmutableLocale.builder().value(site.getLocale()).enabled(Boolean.valueOf(true)).build();
        ImmutableEntity entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LOCALE).body((StencilClient.EntityBody)locale).build();
        this.visitCommit((StencilClient.Entity<?>)entity);
        return entity;
    }

    private String gid(StencilClient.EntityType type) {
        return this.config.getGidProvider().getNextId(type);
    }
}

