/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.serializers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceConfig;
import java.io.IOException;

public class ZoeDeserializer
implements PersistenceConfig.Deserializer {
    private ObjectMapper objectMapper;

    public ZoeDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T extends StencilClient.EntityBody> StencilClient.Entity<T> fromString(StencilClient.EntityType entityType, String value) {
        try {
            switch (entityType) {
                case ARTICLE: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Article>>(){});
                }
                case LINK: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Link>>(){});
                }
                case LOCALE: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Locale>>(){});
                }
                case PAGE: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Page>>(){});
                }
                case RELEASE: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Release>>(){});
                }
                case WORKFLOW: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Workflow>>(){});
                }
            }
            throw new RuntimeException("can't map: " + entityType);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public StencilClient.Entity<?> fromString(String value) {
        try {
            JsonNode node = (JsonNode)this.objectMapper.readValue(value, JsonNode.class);
            StencilClient.EntityType type = StencilClient.EntityType.valueOf((String)node.get("type").textValue());
            switch (type) {
                case ARTICLE: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Article>>(){});
                }
                case LINK: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Link>>(){});
                }
                case LOCALE: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Locale>>(){});
                }
                case PAGE: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Page>>(){});
                }
                case RELEASE: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Release>>(){});
                }
                case WORKFLOW: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Workflow>>(){});
                }
            }
            throw new RuntimeException("can't map: " + node);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage() + System.lineSeparator() + value, e);
        }
    }
}

