/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceConfig;
import io.thestencil.client.spi.exceptions.QueryException;
import io.thestencil.client.spi.exceptions.SaveException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ArticleDeleteVisitor {
    private final PersistenceConfig config;
    private final String articleId;

    public ArticleDeleteVisitor(PersistenceConfig config, String articleId) {
        this.articleId = articleId;
        this.config = config;
    }

    public Uni<StencilClient.Entity<StencilClient.Article>> visit() {
        return this.config.getClient().objects().refState().repo(this.config.getRepoName()).ref(this.config.getHeadName()).blobs().build().onItem().transformToUni(state -> this.visitObjects((ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>)state));
    }

    private Uni<StencilClient.Entity<StencilClient.Article>> visitObjects(ObjectsActions.ObjectsResult<ObjectsActions.RefObjects> state) {
        if (state.getStatus() != ObjectsActions.ObjectsStatus.OK) {
            throw new QueryException(this.articleId, StencilClient.EntityType.ARTICLE, state);
        }
        StencilClient.Entity<StencilClient.Article> start = this.visitArticleId(state, this.articleId);
        CommitActions.HeadCommitBuilder updateCommand = this.config.getClient().commit().head();
        StringBuilder message = new StringBuilder("batch delete type: '" + StencilClient.EntityType.ARTICLE + "', with id: '" + this.articleId + "'");
        for (Objects.TreeValue treeValue : ((ObjectsActions.RefObjects)state.getObjects()).getTree().getValues().values()) {
            Objects.Blob blob = (Objects.Blob)((ObjectsActions.RefObjects)state.getObjects()).getBlobs().get(treeValue.getBlob());
            StencilClient.Entity<?> entity = this.config.getDeserializer().fromString(blob.getValue());
            if (entity.getId().equals(this.articleId)) continue;
            if (entity.getType() == StencilClient.EntityType.PAGE) {
                this.visitPage(entity).ifPresent(changeEntity -> {
                    updateCommand.remove(changeEntity.getId());
                    message.append(System.lineSeparator()).append("deleting type: '" + changeEntity.getType() + "' with id:'" + changeEntity.getId() + "'");
                });
                continue;
            }
            if (entity.getType() == StencilClient.EntityType.WORKFLOW) {
                this.visitWorkflow(entity).ifPresent(changeEntity -> {
                    updateCommand.append(changeEntity.getId(), this.config.getSerializer().toString((StencilClient.Entity<?>)changeEntity));
                    message.append(System.lineSeparator()).append("change type: '" + changeEntity.getType() + "' with id:'" + changeEntity.getId() + "'");
                });
                continue;
            }
            if (entity.getType() == StencilClient.EntityType.LINK) {
                this.visitLink(entity).ifPresent(changeEntity -> {
                    updateCommand.append(changeEntity.getId(), this.config.getSerializer().toString((StencilClient.Entity<?>)changeEntity));
                    message.append(System.lineSeparator()).append("changes type: '" + changeEntity.getType() + "' with id:'" + changeEntity.getId() + "'");
                });
                continue;
            }
            if (entity.getType() != StencilClient.EntityType.ARTICLE) continue;
            this.visitArticle(entity).ifPresent(changeEntity -> {
                updateCommand.append(changeEntity.getId(), this.config.getSerializer().toString((StencilClient.Entity<?>)changeEntity));
                message.append(System.lineSeparator()).append("changes type: '" + changeEntity.getType() + "' with id:'" + changeEntity.getId() + "'");
            });
        }
        return updateCommand.head(this.config.getRepoName(), this.config.getHeadName()).message(message.toString()).parentIsLatest().remove(start.getId()).author(this.config.getAuthorProvider().getAuthor()).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return start;
            }
            throw new SaveException(start, (CommitActions.CommitResult)commit);
        });
    }

    public Optional<StencilClient.Entity<?>> visitArticle(StencilClient.Entity<StencilClient.Article> start) {
        if (((StencilClient.Article)start.getBody()).getParentId() != null && ((StencilClient.Article)start.getBody()).getParentId().equals(this.articleId)) {
            return Optional.of(ImmutableEntity.builder().id(start.getId()).type(start.getType()).body((StencilClient.EntityBody)ImmutableArticle.builder().from((StencilClient.Article)start.getBody()).parentId(null).build()).build());
        }
        return Optional.empty();
    }

    public Optional<StencilClient.Entity<?>> visitLink(StencilClient.Entity<StencilClient.Link> start) {
        List newArticles = ((StencilClient.Link)start.getBody()).getArticles().stream().filter(a -> !a.equals(this.articleId)).collect(Collectors.toList());
        if (newArticles.size() == ((StencilClient.Link)start.getBody()).getArticles().size()) {
            return Optional.empty();
        }
        return Optional.of(ImmutableEntity.builder().id(start.getId()).type(start.getType()).body((StencilClient.EntityBody)ImmutableLink.builder().from((StencilClient.Link)start.getBody()).articles(newArticles).build()).build());
    }

    public Optional<StencilClient.Entity<?>> visitPage(StencilClient.Entity<StencilClient.Page> page) {
        if (((StencilClient.Page)page.getBody()).getArticle().equals(this.articleId)) {
            return Optional.of(page);
        }
        return Optional.empty();
    }

    public Optional<StencilClient.Entity<?>> visitWorkflow(StencilClient.Entity<StencilClient.Workflow> start) {
        List newArticles = ((StencilClient.Workflow)start.getBody()).getArticles().stream().filter(a -> !a.equals(this.articleId)).collect(Collectors.toList());
        if (newArticles.size() == ((StencilClient.Workflow)start.getBody()).getArticles().size()) {
            return Optional.empty();
        }
        return Optional.of(ImmutableEntity.builder().id(start.getId()).type(start.getType()).body((StencilClient.EntityBody)ImmutableWorkflow.builder().from((StencilClient.Workflow)start.getBody()).articles(newArticles).build()).build());
    }

    private StencilClient.Entity<StencilClient.Article> visitArticleId(ObjectsActions.ObjectsResult<ObjectsActions.RefObjects> state, String articleId) {
        Optional<Objects.TreeValue> treeValue = ((ObjectsActions.RefObjects)state.getObjects()).getTree().getValues().values().stream().filter(b -> b.getName().equals(articleId)).findFirst();
        if (treeValue.isEmpty()) {
            throw new QueryException(articleId, StencilClient.EntityType.ARTICLE, state);
        }
        Objects.Blob blob = (Objects.Blob)((ObjectsActions.RefObjects)state.getObjects()).getBlobs().get(treeValue.get().getBlob());
        StencilClient.Entity<?> blobEntity = this.config.getDeserializer().fromString(blob.getValue());
        if (blobEntity.getType() != StencilClient.EntityType.ARTICLE) {
            throw new QueryException(articleId, StencilClient.EntityType.ARTICLE, state);
        }
        return blobEntity;
    }
}

