/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.commits.Sha2;
import io.thestencil.client.api.ImmutableArticleReleaseItem;
import io.thestencil.client.api.ImmutableLinkReleaseItem;
import io.thestencil.client.api.ImmutableLocaleReleaseItem;
import io.thestencil.client.api.ImmutablePageReleaseItem;
import io.thestencil.client.api.ImmutableRelease;
import io.thestencil.client.api.ImmutableSiteState;
import io.thestencil.client.api.ImmutableWorkflowReleaseItem;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceConfig;
import io.thestencil.client.spi.builders.QueryBuilderImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateReleaseVisitor {
    private final StencilClient.SiteState state;
    private final Set<String> enabledLocales = new HashSet<String>();
    private final Set<String> enabledArticles = new HashSet<String>();

    public CreateReleaseVisitor(ObjectsActions.ObjectsResult<ObjectsActions.RefObjects> state, PersistenceConfig config) {
        Objects.Tree tree = ((ObjectsActions.RefObjects)state.getObjects()).getTree();
        Map blobs = ((ObjectsActions.RefObjects)state.getObjects()).getBlobs();
        ImmutableSiteState.Builder builder = QueryBuilderImpl.mapTree(tree, blobs, config);
        Objects.Commit commit = ((ObjectsActions.RefObjects)state.getObjects()).getCommit();
        this.state = builder.commit(commit.getId()).name("release").contentType(StencilClient.SiteContentType.OK).build();
    }

    public ImmutableRelease.Builder visit(ImmutableRelease.Builder releaseBuilder) {
        return releaseBuilder.addAllLocales(this.visitLocale()).addAllPages(this.visitPage()).addAllArticles(this.visitArticle()).addAllWorkflows(this.visitWorkflow()).addAllLinks(this.visitLink());
    }

    private List<StencilClient.LocaleReleaseItem> visitLocale() {
        ArrayList<StencilClient.LocaleReleaseItem> result = new ArrayList<StencilClient.LocaleReleaseItem>();
        for (StencilClient.Entity locale : this.state.getLocales().values()) {
            if (!((StencilClient.Locale)locale.getBody()).getEnabled().booleanValue()) continue;
            this.enabledLocales.add(locale.getId());
            result.add((StencilClient.LocaleReleaseItem)ImmutableLocaleReleaseItem.builder().id(locale.getId()).value(((StencilClient.Locale)locale.getBody()).getValue()).hash(Sha2.blobId((String)((StencilClient.Locale)locale.getBody()).getValue().toString())).build());
        }
        return result;
    }

    private List<StencilClient.PageReleaseItem> visitPage() {
        ArrayList<StencilClient.PageReleaseItem> result = new ArrayList<StencilClient.PageReleaseItem>();
        for (StencilClient.Entity page : this.state.getPages().values()) {
            if (!this.enabledLocales.contains(((StencilClient.Page)page.getBody()).getLocale())) continue;
            this.enabledArticles.add(((StencilClient.Page)page.getBody()).getArticle());
            result.add((StencilClient.PageReleaseItem)ImmutablePageReleaseItem.builder().id(page.getId()).hash(Sha2.blobId((String)((StencilClient.Page)page.getBody()).toString())).locale(((StencilClient.Page)page.getBody()).getLocale()).h1(this.visitH1((StencilClient.Entity<StencilClient.Page>)page)).build());
        }
        return result;
    }

    private String visitH1(StencilClient.Entity<StencilClient.Page> page) {
        int h1Start = ((StencilClient.Page)page.getBody()).getContent().indexOf("# ");
        if (h1Start < 0) {
            return "";
        }
        int lineEnd = ((StencilClient.Page)page.getBody()).getContent().indexOf("\r\n", h1Start);
        if (lineEnd < 0) {
            lineEnd = ((StencilClient.Page)page.getBody()).getContent().indexOf("\n", h1Start);
        }
        if (lineEnd < 0) {
            return ((StencilClient.Page)page.getBody()).getContent().substring(2).trim();
        }
        return ((StencilClient.Page)page.getBody()).getContent().substring(2, lineEnd).trim();
    }

    private List<StencilClient.ArticleReleaseItem> visitArticle() {
        ArrayList<StencilClient.ArticleReleaseItem> result = new ArrayList<StencilClient.ArticleReleaseItem>();
        for (StencilClient.Entity article : this.state.getArticles().values()) {
            if (!this.enabledArticles.contains(article.getId())) continue;
            ImmutableArticleReleaseItem item = ImmutableArticleReleaseItem.builder().id(article.getId()).hash("").parentId(((StencilClient.Article)article.getBody()).getParentId()).name(((StencilClient.Article)article.getBody()).getName()).build();
            result.add((StencilClient.ArticleReleaseItem)ImmutableArticleReleaseItem.builder().from((StencilClient.ArticleReleaseItem)item).hash(Sha2.blobId((String)item.toString())).build());
        }
        return result;
    }

    private List<StencilClient.LinkReleaseItem> visitLink() {
        ArrayList<StencilClient.LinkReleaseItem> result = new ArrayList<StencilClient.LinkReleaseItem>();
        for (StencilClient.Entity link : this.state.getLinks().values()) {
            List labels = ((StencilClient.Link)link.getBody()).getLabels().stream().filter(label -> this.enabledLocales.contains(label.getLocale())).collect(Collectors.toList());
            List articles = ((StencilClient.Link)link.getBody()).getArticles().stream().filter(article -> this.enabledArticles.contains(article)).collect(Collectors.toList());
            if (articles.isEmpty() || labels.isEmpty()) continue;
            ImmutableLinkReleaseItem item = ImmutableLinkReleaseItem.builder().id(link.getId()).hash("").contentType(((StencilClient.Link)link.getBody()).getContentType()).value(((StencilClient.Link)link.getBody()).getValue()).addAllLabels(labels).addAllArticles(articles).build();
            result.add((StencilClient.LinkReleaseItem)ImmutableLinkReleaseItem.builder().from((StencilClient.LinkReleaseItem)item).hash(Sha2.blobId((String)item.toString())).build());
        }
        return result;
    }

    private List<StencilClient.WorkflowReleaseItem> visitWorkflow() {
        ArrayList<StencilClient.WorkflowReleaseItem> result = new ArrayList<StencilClient.WorkflowReleaseItem>();
        for (StencilClient.Entity workflow : this.state.getWorkflows().values()) {
            List labels = ((StencilClient.Workflow)workflow.getBody()).getLabels().stream().filter(label -> this.enabledLocales.contains(label.getLocale())).collect(Collectors.toList());
            List articles = ((StencilClient.Workflow)workflow.getBody()).getArticles().stream().filter(article -> this.enabledArticles.contains(article)).collect(Collectors.toList());
            if (articles.isEmpty() || labels.isEmpty()) continue;
            ImmutableWorkflowReleaseItem item = ImmutableWorkflowReleaseItem.builder().id(workflow.getId()).hash("").value(((StencilClient.Workflow)workflow.getBody()).getValue()).addAllLabels(labels).addAllArticles(articles).build();
            result.add((StencilClient.WorkflowReleaseItem)ImmutableWorkflowReleaseItem.builder().from((StencilClient.WorkflowReleaseItem)item).hash(Sha2.blobId((String)item.toString())).build());
        }
        return result;
    }
}

