/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.DeleteBuilder;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceCommands;
import io.thestencil.client.spi.PersistenceConfig;
import io.thestencil.client.spi.builders.ArticleDeleteVisitor;
import java.util.List;
import java.util.stream.Collectors;

public class DeleteBuilderImpl
extends PersistenceCommands
implements DeleteBuilder {
    public DeleteBuilderImpl(PersistenceConfig config) {
        super(config);
    }

    public Uni<StencilClient.Entity<StencilClient.Article>> article(String articleId) {
        return new ArticleDeleteVisitor(this.config, articleId).visit();
    }

    public Uni<StencilClient.Entity<StencilClient.Locale>> locale(String localeId) {
        Uni query = this.get(localeId, StencilClient.EntityType.LOCALE);
        return query.onItem().transformToUni(state -> this.delete(state.getEntity()));
    }

    public Uni<StencilClient.Entity<StencilClient.Page>> page(String pageId) {
        Uni query = this.get(pageId, StencilClient.EntityType.PAGE);
        return query.onItem().transformToUni(state -> this.delete(state.getEntity()));
    }

    public Uni<StencilClient.Entity<StencilClient.Link>> link(String linkId) {
        Uni query = this.get(linkId, StencilClient.EntityType.LINK);
        return query.onItem().transformToUni(state -> this.delete(state.getEntity()));
    }

    public Uni<StencilClient.Entity<StencilClient.Workflow>> workflow(String workflowId) {
        Uni query = this.get(workflowId, StencilClient.EntityType.WORKFLOW);
        return query.onItem().transformToUni(state -> this.delete(state.getEntity()));
    }

    public Uni<StencilClient.Entity<StencilClient.Link>> linkArticlePage(DeleteBuilder.LinkArticlePage linkArticlePage) {
        Uni query = this.get(linkArticlePage.getLinkId(), StencilClient.EntityType.LINK);
        return query.onItem().transformToUni(state -> {
            StencilClient.Entity start = state.getEntity();
            List newArticles = ((StencilClient.Link)start.getBody()).getArticles().stream().filter(a -> !a.equals(linkArticlePage.getArticleId())).collect(Collectors.toList());
            if (newArticles.size() == ((StencilClient.Link)start.getBody()).getArticles().size()) {
                return Uni.createFrom().item(start);
            }
            ImmutableEntity end = ImmutableEntity.builder().id(start.getId()).type(start.getType()).body((StencilClient.EntityBody)ImmutableLink.builder().from((StencilClient.Link)start.getBody()).articles(newArticles).build()).build();
            return this.save(end);
        });
    }

    public Uni<StencilClient.Entity<StencilClient.Workflow>> workflowArticlePage(DeleteBuilder.WorkflowArticlePage workflowArticlePage) {
        Uni query = this.get(workflowArticlePage.getWorkflowId(), StencilClient.EntityType.WORKFLOW);
        return query.onItem().transformToUni(state -> {
            StencilClient.Entity start = state.getEntity();
            List newArticles = ((StencilClient.Workflow)start.getBody()).getArticles().stream().filter(a -> !a.equals(workflowArticlePage.getArticleId())).collect(Collectors.toList());
            if (newArticles.size() == ((StencilClient.Workflow)start.getBody()).getArticles().size()) {
                return Uni.createFrom().item(start);
            }
            ImmutableEntity end = ImmutableEntity.builder().id(start.getId()).type(start.getType()).body((StencilClient.EntityBody)ImmutableWorkflow.builder().from((StencilClient.Workflow)start.getBody()).articles(newArticles).build()).build();
            return this.save(end);
        });
    }
}

