/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.api.actions.CommitActions;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceConfig;
import io.thestencil.client.spi.builders.MigrationImportVisitor;
import io.thestencil.client.spi.builders.QueryBuilderImpl;
import io.thestencil.client.spi.exceptions.ImportException;

public class MigrationBuilderImpl
implements MigrationBuilder {
    private final PersistenceConfig config;

    public MigrationBuilderImpl(PersistenceConfig config) {
        this.config = config;
    }

    public Uni<StencilClient.SiteState> importData(MigrationBuilder.Sites sites) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(site -> {
            CommitActions.HeadCommitBuilder builder = new MigrationImportVisitor(this.config, (StencilClient.SiteState)site).visit(sites).head(this.config.getRepoName(), this.config.getHeadName());
            if (site.getContentType() == StencilClient.SiteContentType.OK) {
                builder.parent(site.getCommit());
            } else {
                builder.parentIsLatest();
            }
            return builder.message("import-sites").author(this.config.getAuthorProvider().getAuthor()).build().onItem().transformToUni(commit -> {
                if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                    return new QueryBuilderImpl(this.config).head();
                }
                throw new ImportException(sites, (CommitActions.CommitResult)commit);
            });
        });
    }
}

