/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableSiteState;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceCommands;
import io.thestencil.client.spi.PersistenceConfig;
import io.thestencil.client.spi.exceptions.QueryException;
import io.thestencil.client.spi.exceptions.RefException;
import java.util.Map;

public class QueryBuilderImpl
extends PersistenceCommands
implements StencilClient.QueryBuilder {
    public QueryBuilderImpl(PersistenceConfig config) {
        super(config);
    }

    public Uni<StencilClient.SiteState> head() {
        String siteName = this.config.getRepoName() + ":" + this.config.getHeadName();
        return this.config.getClient().repo().query().id(this.config.getRepoName()).get().onItem().transformToUni(repo -> {
            if (repo == null) {
                return Uni.createFrom().item((Object)ImmutableSiteState.builder().name(siteName).contentType(StencilClient.SiteContentType.NOT_CREATED).build());
            }
            return this.config.getClient().objects().refState().repo(this.config.getRepoName()).ref(this.config.getHeadName()).blobs(true).build().onItem().transform(state -> {
                if (state.getStatus() == ObjectsActions.ObjectsStatus.ERROR) {
                    throw new RefException(siteName, (ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>)state);
                }
                if (state.getObjects() == null) {
                    return ImmutableSiteState.builder().name(siteName).contentType(StencilClient.SiteContentType.EMPTY).build();
                }
                Objects.Commit commit = ((ObjectsActions.RefObjects)state.getObjects()).getCommit();
                Objects.Tree tree = ((ObjectsActions.RefObjects)state.getObjects()).getTree();
                Map blobs = ((ObjectsActions.RefObjects)state.getObjects()).getBlobs();
                ImmutableSiteState.Builder builder = QueryBuilderImpl.mapTree(tree, blobs, this.config);
                return builder.commit(commit.getId()).name(siteName).contentType(StencilClient.SiteContentType.OK).build();
            });
        });
    }

    public static ImmutableSiteState.Builder mapTree(Objects.Tree tree, Map<String, Objects.Blob> blobs, PersistenceConfig config) {
        ImmutableSiteState.Builder builder = ImmutableSiteState.builder();
        block8: for (Objects.TreeValue treeValue : tree.getValues().values()) {
            Objects.Blob blob = blobs.get(treeValue.getBlob());
            StencilClient.Entity<?> entity = config.getDeserializer().fromString(blob.getValue());
            String id = entity.getId();
            switch (entity.getType()) {
                case ARTICLE: {
                    builder.putArticles(id, entity);
                    continue block8;
                }
                case LINK: {
                    builder.putLinks(id, entity);
                    continue block8;
                }
                case LOCALE: {
                    builder.putLocales(id, entity);
                    continue block8;
                }
                case PAGE: {
                    builder.putPages(id, entity);
                    continue block8;
                }
                case RELEASE: {
                    builder.putReleases(id, entity);
                    continue block8;
                }
                case WORKFLOW: {
                    builder.putWorkflows(id, entity);
                    continue block8;
                }
            }
            throw new RuntimeException("Don't know how to convert entity: " + entity.toString() + "!");
        }
        return builder;
    }

    public Uni<StencilClient.SiteState> release(String releaseId) {
        Uni query = this.get(releaseId, StencilClient.EntityType.RELEASE);
        return query.onItem().transformToUni(this::getCommitState);
    }

    private Uni<StencilClient.SiteState> getCommitState(PersistenceConfig.EntityState<StencilClient.Release> release) {
        return this.config.getClient().objects().commitState().repo(this.config.getRepoName()).anyId(((StencilClient.Release)release.getEntity().getBody()).getParentCommit()).blobs(true).build().onItem().transform(state -> {
            if (state.getStatus() == ObjectsActions.ObjectsStatus.ERROR) {
                throw new QueryException("Can't find release commit: '" + ((StencilClient.Release)release.getEntity().getBody()).getParentCommit() + "'!", StencilClient.EntityType.RELEASE, (ObjectsActions.ObjectsResult<?>)state);
            }
            Objects.Tree tree = ((ObjectsActions.CommitObjects)state.getObjects()).getTree();
            Map blobs = ((ObjectsActions.CommitObjects)state.getObjects()).getBlobs();
            ImmutableSiteState.Builder builder = QueryBuilderImpl.mapTree(tree, blobs, this.config).putReleases(release.getEntity().getId(), release.getEntity());
            return builder.name(this.config.getRepoName() + ":" + this.config.getHeadName() + ":" + ((StencilClient.Release)release.getEntity().getBody()).getName()).contentType(StencilClient.SiteContentType.RELEASE).build();
        });
    }
}

