/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableLocale;
import io.thestencil.client.api.ImmutablePage;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.UpdateBuilder;
import io.thestencil.client.spi.PersistenceCommands;
import io.thestencil.client.spi.PersistenceConfig;
import io.thestencil.client.spi.builders.QueryBuilderImpl;
import io.thestencil.client.spi.exceptions.ConstraintException;
import io.thestencil.client.spi.exceptions.QueryException;
import io.thestencil.client.spi.exceptions.SaveException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UpdateBuilderImpl
extends PersistenceCommands
implements UpdateBuilder {
    public UpdateBuilderImpl(PersistenceConfig config) {
        super(config);
    }

    public Uni<StencilClient.Entity<StencilClient.Article>> article(UpdateBuilder.ArticleMutator changes) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> this.changeArticle((StencilClient.SiteState)state, changes));
    }

    private Uni<StencilClient.Entity<StencilClient.Article>> changeArticle(StencilClient.SiteState site, UpdateBuilder.ArticleMutator changes) {
        ArrayList articles;
        StencilClient.Entity start = (StencilClient.Entity)site.getArticles().get(changes.getArticleId());
        ArrayList<ImmutableEntity> additionalChanges = new ArrayList<ImmutableEntity>();
        Optional<StencilClient.Entity> duplicate = site.getArticles().values().stream().filter(p -> !p.getId().equals(changes.getArticleId())).filter(p -> ((StencilClient.Article)p.getBody()).getName().equals(changes.getName())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(start, "Article: '" + changes.getName() + "' already exists!");
        }
        if (changes.getLinks() != null) {
            for (StencilClient.Entity link : site.getLinks().values()) {
                boolean isArticleInLink = ((StencilClient.Link)link.getBody()).getArticles().contains(changes.getArticleId());
                boolean isLinkInChanges = changes.getLinks().contains(link.getId());
                if (isArticleInLink && isLinkInChanges) continue;
                if (isLinkInChanges && !isArticleInLink) {
                    ImmutableEntity newLink = ImmutableEntity.builder().from(link).body((StencilClient.EntityBody)ImmutableLink.builder().from((StencilClient.Link)link.getBody()).addArticles(changes.getArticleId()).build()).build();
                    additionalChanges.add(newLink);
                }
                if (!isArticleInLink || isLinkInChanges) continue;
                articles = new ArrayList(((StencilClient.Link)link.getBody()).getArticles());
                articles.remove(changes.getArticleId());
                ImmutableEntity newLink = ImmutableEntity.builder().from(link).body((StencilClient.EntityBody)ImmutableLink.builder().from((StencilClient.Link)link.getBody()).articles(articles).build()).build();
                additionalChanges.add(newLink);
            }
        }
        if (changes.getWorkflows() != null) {
            for (StencilClient.Entity workflow : site.getWorkflows().values()) {
                boolean isArticleInWorkflow = ((StencilClient.Workflow)workflow.getBody()).getArticles().contains(changes.getArticleId());
                boolean isWorkflowInChanges = changes.getWorkflows().contains(workflow.getId());
                if (isArticleInWorkflow && isWorkflowInChanges) continue;
                if (isWorkflowInChanges && !isArticleInWorkflow) {
                    ImmutableEntity newWorkflow = ImmutableEntity.builder().from(workflow).body((StencilClient.EntityBody)ImmutableWorkflow.builder().from((StencilClient.Workflow)workflow.getBody()).addArticles(changes.getArticleId()).build()).build();
                    additionalChanges.add(newWorkflow);
                }
                if (!isArticleInWorkflow || isWorkflowInChanges) continue;
                articles = new ArrayList(((StencilClient.Workflow)workflow.getBody()).getArticles());
                articles.remove(changes.getArticleId());
                ImmutableEntity newWorkflow = ImmutableEntity.builder().from(workflow).body((StencilClient.EntityBody)ImmutableWorkflow.builder().from((StencilClient.Workflow)workflow.getBody()).articles(articles).build()).build();
                additionalChanges.add(newWorkflow);
            }
        }
        ImmutableEntity result = ImmutableEntity.builder().from(start).body((StencilClient.EntityBody)ImmutableArticle.builder().from((StencilClient.Article)start.getBody()).name(changes.getName()).order(changes.getOrder()).parentId(changes.getParentId()).build()).build();
        ArrayList allChanges = new ArrayList();
        allChanges.add((StencilClient.Entity<?>)result);
        allChanges.addAll(additionalChanges);
        return this.save(allChanges).onItem().transform(e -> result);
    }

    public Uni<StencilClient.Entity<StencilClient.Locale>> locale(UpdateBuilder.LocaleMutator changes) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> this.save(this.changeLocale((StencilClient.SiteState)state, changes)));
    }

    private StencilClient.Entity<StencilClient.Locale> changeLocale(StencilClient.SiteState site, UpdateBuilder.LocaleMutator changes) {
        StencilClient.Entity start = (StencilClient.Entity)site.getLocales().get(changes.getLocaleId());
        Optional<StencilClient.Entity> duplicate = site.getLocales().values().stream().filter(p -> !p.getId().equals(changes.getLocaleId())).filter(p -> ((StencilClient.Locale)p.getBody()).getValue().equals(changes.getValue())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(start, "Locale: '" + changes.getValue() + "' already exists!");
        }
        return ImmutableEntity.builder().from(start).body((StencilClient.EntityBody)ImmutableLocale.builder().from((StencilClient.Locale)start.getBody()).value(changes.getValue()).enabled(changes.getEnabled()).build()).build();
    }

    public Uni<StencilClient.Entity<StencilClient.Page>> page(UpdateBuilder.PageMutator changes) {
        Uni query = this.get(changes.getPageId(), StencilClient.EntityType.PAGE);
        return query.onItem().transformToUni(state -> this.save(this.changePage((PersistenceConfig.EntityState<StencilClient.Page>)state, changes)));
    }

    public Uni<List<StencilClient.Entity<StencilClient.Page>>> pages(List<UpdateBuilder.PageMutator> mutators) {
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<String, UpdateBuilder.PageMutator> changes = new HashMap<String, UpdateBuilder.PageMutator>();
        for (UpdateBuilder.PageMutator m : mutators) {
            changes.put(m.getPageId(), m);
            ids.add(m.getPageId());
        }
        return this.config.getClient().objects().blobState().repo(this.config.getRepoName()).anyId(this.config.getHeadName()).blobNames(ids).list().onItem().transformToUni(state -> {
            if (state.getStatus() != ObjectsActions.ObjectsStatus.OK) {
                throw new QueryException(String.join((CharSequence)",", ids), StencilClient.EntityType.PAGE, (ObjectsActions.ObjectsResult<?>)state);
            }
            List<StencilClient.Entity> toBeSaved = ((ObjectsActions.BlobObjects)state.getObjects()).getBlob().stream().map(blob -> {
                StencilClient.Entity start = this.config.getDeserializer().fromString(StencilClient.EntityType.PAGE, blob.getValue());
                UpdateBuilder.PageMutator mutator = (UpdateBuilder.PageMutator)changes.get(start.getId());
                ImmutableEntity end = ImmutableEntity.builder().from(start).body((StencilClient.EntityBody)ImmutablePage.builder().from((StencilClient.Page)start.getBody()).content(mutator.getContent()).locale(mutator.getLocale()).build()).build();
                return end;
            }).collect(Collectors.toList());
            CommitActions.HeadCommitBuilder command = this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName());
            toBeSaved.forEach(e -> command.append(e.getId(), this.config.getSerializer().toString((StencilClient.Entity<?>)e)));
            return command.message("UPDATE: '" + StencilClient.EntityType.PAGE + "', count: '" + ids.size() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).build().onItem().transform(commit -> {
                if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                    return toBeSaved;
                }
                throw new SaveException(new ArrayList(toBeSaved), (CommitActions.CommitResult)commit);
            });
        });
    }

    private StencilClient.Entity<StencilClient.Page> changePage(PersistenceConfig.EntityState<StencilClient.Page> state, UpdateBuilder.PageMutator changes) {
        StencilClient.Entity<StencilClient.Page> start = state.getEntity();
        return ImmutableEntity.builder().from(start).body((StencilClient.EntityBody)ImmutablePage.builder().from((StencilClient.Page)start.getBody()).content(changes.getContent()).locale(changes.getLocale()).build()).build();
    }

    public Uni<StencilClient.Entity<StencilClient.Link>> link(UpdateBuilder.LinkMutator changes) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> this.save(this.changeLink((StencilClient.SiteState)state, changes)));
    }

    private StencilClient.Entity<StencilClient.Link> changeLink(StencilClient.SiteState site, UpdateBuilder.LinkMutator changes) {
        StencilClient.Entity start = (StencilClient.Entity)site.getLinks().get(changes.getLinkId());
        if (changes.getLabels() != null) {
            for (StencilClient.LocaleLabel label : changes.getLabels()) {
                String localeId = label.getLocale();
                if (site.getLocales().containsKey(localeId)) continue;
                throw new ConstraintException(start, "Locale with id: '" + localeId + "' does not exist in: '" + String.join((CharSequence)",", site.getLocales().keySet()) + "'!");
            }
        }
        return ImmutableEntity.builder().from(start).body((StencilClient.EntityBody)ImmutableLink.builder().from((StencilClient.Link)start.getBody()).value(changes.getValue()).labels((Iterable)(changes.getLabels() == null ? ((StencilClient.Link)start.getBody()).getLabels() : changes.getLabels())).contentType(changes.getType()).articles((Iterable)(changes.getArticles() == null ? ((StencilClient.Link)start.getBody()).getArticles() : changes.getArticles())).build()).build();
    }

    public Uni<StencilClient.Entity<StencilClient.Workflow>> workflow(UpdateBuilder.WorkflowMutator changes) {
        Uni<StencilClient.SiteState> query = new QueryBuilderImpl(this.config).head();
        return query.onItem().transformToUni(state -> this.save(this.changeWorkflow((StencilClient.SiteState)state, changes)));
    }

    private StencilClient.Entity<StencilClient.Workflow> changeWorkflow(StencilClient.SiteState site, UpdateBuilder.WorkflowMutator changes) {
        StencilClient.Entity start = (StencilClient.Entity)site.getWorkflows().get(changes.getWorkflowId());
        if (changes.getLabels() != null) {
            for (StencilClient.LocaleLabel label : changes.getLabels()) {
                String localeId = label.getLocale();
                if (site.getLocales().containsKey(localeId)) continue;
                throw new ConstraintException(start, "Locale with id: '" + localeId + "' does not exist in: '" + String.join((CharSequence)",", site.getLocales().keySet()) + "'!");
            }
        }
        return ImmutableEntity.builder().from(start).body((StencilClient.EntityBody)ImmutableWorkflow.builder().from((StencilClient.Workflow)start.getBody()).devMode(changes.getDevMode()).value(changes.getValue()).labels((Iterable)(changes.getLabels() == null ? ((StencilClient.Workflow)start.getBody()).getLabels() : changes.getLabels())).articles((Iterable)(changes.getArticles() == null ? ((StencilClient.Workflow)start.getBody()).getArticles() : changes.getArticles())).build()).build();
    }
}

