/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.exceptions;

import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Message;
import io.thestencil.client.api.StencilClient;
import java.util.List;

public class QueryException
extends RuntimeException {
    private static final long serialVersionUID = 7190168525508589141L;
    private final String entityId;
    private final StencilClient.EntityType type;
    private final List<Message> commit;

    public QueryException(String entityId, StencilClient.EntityType type, ObjectsActions.ObjectsResult<?> commit) {
        super(QueryException.msg(entityId, type, commit.getMessages()));
        this.entityId = entityId;
        this.type = type;
        this.commit = commit.getMessages();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public StencilClient.EntityType getType() {
        return this.type;
    }

    public List<Message> getCommit() {
        return this.commit;
    }

    private static String msg(String entityId, StencilClient.EntityType type, List<Message> commit) {
        StringBuilder messages = new StringBuilder();
        for (Message msg : commit) {
            messages.append(System.lineSeparator()).append("  - ").append(msg.getText());
        }
        return "Can't find entity: " + type + ", id: " + entityId + ", because of: " + messages;
    }
}

