/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.CreateBuilder;
import io.thestencil.client.api.DeleteBuilder;
import io.thestencil.client.api.ImmutableArticleMutator;
import io.thestencil.client.api.ImmutableCreateArticle;
import io.thestencil.client.api.ImmutableCreateLink;
import io.thestencil.client.api.ImmutableCreateLocale;
import io.thestencil.client.api.ImmutableCreatePage;
import io.thestencil.client.api.ImmutableCreateRelease;
import io.thestencil.client.api.ImmutableCreateWorkflow;
import io.thestencil.client.api.ImmutableLinkArticlePage;
import io.thestencil.client.api.ImmutableLinkMutator;
import io.thestencil.client.api.ImmutableLocaleMutator;
import io.thestencil.client.api.ImmutableWorkflowArticlePage;
import io.thestencil.client.api.ImmutableWorkflowMutator;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.UpdateBuilder;
import io.thestencil.client.api.beans.SitesBean;
import io.thestencil.client.web.HandlerContext;
import io.thestencil.client.web.HandlerStatusCodes;
import io.thestencil.client.web.HandlerTemplate;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.List;

public class HandlerComposer
extends HandlerTemplate {
    public HandlerComposer(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        super(currentIdentityAssociation, currentVertxRequest);
    }

    @Override
    protected void handleResource(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
        String path = this.getPath(event);
        StencilClient client = ctx.getClient();
        if (path.endsWith(ctx.getPaths().getServicePath())) {
            if (event.request().method() == HttpMethod.POST) {
                client.create().repo().onItem().transform(data -> JsonObject.mapFrom((Object)data).toBuffer()).onFailure().invoke(e -> HandlerStatusCodes.catch422(e, response)).subscribe().with(data -> response.end(data));
            } else if (event.request().method() == HttpMethod.GET) {
                this.subscribe(client.query().head(), response, ctx, objectMapper);
            } else {
                HandlerStatusCodes.catch404("unsupported repository action", response);
            }
        } else if (path.startsWith(ctx.getPaths().getMigrationPath())) {
            if (event.request().method() == HttpMethod.POST) {
                this.subscribe(client.migration().importData((MigrationBuilder.Sites)this.read(event, objectMapper, SitesBean.class)), response, ctx, objectMapper);
            } else {
                HandlerStatusCodes.catch404("unsupported migration action", response);
            }
        } else if (path.startsWith(ctx.getPaths().getArticlesPath())) {
            if (event.request().method() == HttpMethod.POST) {
                this.subscribe(client.create().article((CreateBuilder.CreateArticle)this.read(event, objectMapper, ImmutableCreateArticle.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.PUT) {
                this.subscribe(client.update().article((UpdateBuilder.ArticleMutator)this.read(event, objectMapper, ImmutableArticleMutator.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.DELETE) {
                this.subscribe(client.delete().article(event.pathParam("id")), response, ctx, objectMapper);
            } else {
                HandlerStatusCodes.catch404("unsupported article action", response);
            }
        } else if (path.startsWith(ctx.getPaths().getLinksPath())) {
            if (event.request().method() == HttpMethod.POST) {
                this.subscribe(client.create().link((CreateBuilder.CreateLink)this.read(event, objectMapper, ImmutableCreateLink.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.PUT) {
                this.subscribe(client.update().link((UpdateBuilder.LinkMutator)this.read(event, objectMapper, ImmutableLinkMutator.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.DELETE) {
                String linkId = event.pathParam("id");
                List articleId = event.queryParam("articleId");
                if (articleId.isEmpty()) {
                    this.subscribe(client.delete().link(linkId), response, ctx, objectMapper);
                } else {
                    this.subscribe(client.delete().linkArticlePage((DeleteBuilder.LinkArticlePage)ImmutableLinkArticlePage.builder().articleId((String)articleId.iterator().next()).linkId(linkId).build()), response, ctx, objectMapper);
                }
            } else {
                HandlerStatusCodes.catch404("unsupported links action", response);
            }
        } else if (path.startsWith(ctx.getPaths().getLocalePath())) {
            if (event.request().method() == HttpMethod.POST) {
                this.subscribe(client.create().locale((CreateBuilder.CreateLocale)this.read(event, objectMapper, ImmutableCreateLocale.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.PUT) {
                this.subscribe(client.update().locale((UpdateBuilder.LocaleMutator)this.read(event, objectMapper, ImmutableLocaleMutator.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.DELETE) {
                this.subscribe(client.delete().locale(event.pathParam("id")), response, ctx, objectMapper);
            } else {
                HandlerStatusCodes.catch404("unsupported locale action", response);
            }
        } else if (path.startsWith(ctx.getPaths().getReleasesPath())) {
            if (event.request().method() == HttpMethod.POST) {
                this.subscribe(client.create().release((CreateBuilder.CreateRelease)this.read(event, objectMapper, ImmutableCreateRelease.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.GET) {
                this.subscribe(client.query().release(event.pathParam("id")), response, ctx, objectMapper);
            } else {
                HandlerStatusCodes.catch404("unsupported release action", response);
            }
        } else if (path.startsWith(ctx.getPaths().getWorkflowsPath())) {
            if (event.request().method() == HttpMethod.POST) {
                this.subscribe(client.create().workflow((CreateBuilder.CreateWorkflow)this.read(event, objectMapper, ImmutableCreateWorkflow.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.PUT) {
                this.subscribe(client.update().workflow((UpdateBuilder.WorkflowMutator)this.read(event, objectMapper, ImmutableWorkflowMutator.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.DELETE) {
                String workflowId = event.pathParam("id");
                List articleId = event.queryParam("articleId");
                if (articleId.isEmpty()) {
                    this.subscribe(client.delete().workflow(workflowId), response, ctx, objectMapper);
                } else {
                    this.subscribe(client.delete().workflowArticlePage((DeleteBuilder.WorkflowArticlePage)ImmutableWorkflowArticlePage.builder().articleId((String)articleId.iterator().next()).workflowId(workflowId).build()), response, ctx, objectMapper);
                }
            } else {
                HandlerStatusCodes.catch404("unsupported workflow action", response);
            }
        } else if (path.startsWith(ctx.getPaths().getPagesPath())) {
            if (event.request().method() == HttpMethod.POST) {
                this.subscribe(client.create().page((CreateBuilder.CreatePage)this.read(event, objectMapper, ImmutableCreatePage.class)), response, ctx, objectMapper);
            } else if (event.request().method() == HttpMethod.PUT) {
                try {
                    List pages = (List)objectMapper.readValue(event.getBody().getBytes(), (TypeReference)new TypeReference<List<UpdateBuilder.PageMutator>>(){});
                    this.subscribe(client.update().pages(pages), response, ctx, objectMapper);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2.getMessage(), e2);
                }
            } else if (event.request().method() == HttpMethod.DELETE) {
                this.subscribe(client.delete().page(event.pathParam("id")), response, ctx, objectMapper);
            } else {
                HandlerStatusCodes.catch404("unsupported page action", response);
            }
        } else {
            HandlerStatusCodes.catch404("unsupported action", response);
        }
    }

    public String getPath(RoutingContext event) {
        String path = event.normalizedPath();
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public <T> T read(RoutingContext event, ObjectMapper objectMapper, Class<T> type) {
        try {
            return (T)objectMapper.readValue(event.getBody().getBytes(), type);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T> List<T> readList(RoutingContext event, ObjectMapper objectMapper, Class<T> type) {
        try {
            return (List)objectMapper.readValue(event.getBody().getBytes(), new TypeReference<List<T>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T> void subscribe(Uni<T> uni, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        uni.onItem().transform(data -> {
            try {
                return Buffer.buffer((byte[])objectMapper.writeValueAsBytes(data));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }).onFailure().invoke(e -> HandlerStatusCodes.catch422(e, response)).subscribe().with(data -> response.end(data));
    }
}

