/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.web;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerStatusCodes {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerStatusCodes.class);

    public static void catch404(String id, HttpServerResponse response) {
        String log = "Token not found with id: " + id;
        String hash = HandlerStatusCodes.exceptionHash(log);
        LOGGER.error(hash + " - " + log);
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("appcode", hash);
        response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
        response.setStatusCode(404);
        response.end(Json.encode(msg));
    }

    public static void catch422(Throwable e, HttpServerResponse response) {
        String stack = ExceptionUtils.getStackTrace((Throwable)e);
        String log = e.getMessage() + System.lineSeparator() + stack;
        String hash = HandlerStatusCodes.exceptionHash(log);
        LOGGER.error(hash + " - " + log);
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("appcode", hash);
        response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
        response.setStatusCode(422);
        response.end(Json.encode(msg));
    }

    public static String exceptionHash(String msg) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(msg.getBytes(Charset.forName("UTF-8")));
            byte[] digest = md5.digest();
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn("MD5 Digester not found, falling back to timestamp hash", (Throwable)ex);
            long timestamp = System.currentTimeMillis();
            return Long.toHexString(timestamp);
        }
    }
}

