/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.thestencil.client.web.HandlerContext;
import io.thestencil.client.web.HandlerStatusCodes;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;

public abstract class HandlerTemplate
implements Handler<RoutingContext> {
    private final CurrentIdentityAssociation currentIdentityAssociation;
    private final CurrentVertxRequest currentVertxRequest;

    public HandlerTemplate(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        this.currentIdentityAssociation = currentIdentityAssociation;
        this.currentVertxRequest = currentVertxRequest;
    }

    protected abstract void handleResource(RoutingContext var1, HttpServerResponse var2, HandlerContext var3, ObjectMapper var4);

    protected void handleSecurity(RoutingContext event) {
        if (this.currentIdentityAssociation != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)event.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.currentIdentityAssociation.setIdentity(identity);
            } else {
                this.currentIdentityAssociation.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)event, null));
            }
        }
        this.currentVertxRequest.setCurrent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext event) {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            this.handleSecurity(event);
            HttpServerResponse response = event.response();
            HandlerContext ctx = (HandlerContext)CDI.current().select(HandlerContext.class, new Annotation[0]).get();
            ObjectMapper objectMapper = (ObjectMapper)CDI.current().select(ObjectMapper.class, new Annotation[0]).get();
            try {
                this.handleResource(event, response, ctx, objectMapper);
            }
            catch (Exception e) {
                HandlerStatusCodes.catch422(e, response);
            }
            return;
        }
        HttpServerResponse response = event.response();
        HandlerContext ctx = (HandlerContext)CDI.current().select(HandlerContext.class, new Annotation[0]).get();
        ObjectMapper objectMapper = (ObjectMapper)CDI.current().select(ObjectMapper.class, new Annotation[0]).get();
        try {
            requestContext.activate();
            this.handleSecurity(event);
            this.handleResource(event, response, ctx, objectMapper);
        }
        catch (Exception e) {
            HandlerStatusCodes.catch422(e, response);
        }
        finally {
            requestContext.terminate();
        }
    }
}

