package io.thestencil.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.DocDB;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PersistenceConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePersistenceConfig.builder()}.
 */
@Generated(from = "PersistenceConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePersistenceConfig implements PersistenceConfig {
  private final DocDB client;
  private final String repoName;
  private final String headName;
  private final PersistenceConfig.AuthorProvider authorProvider;
  private final PersistenceConfig.Serializer serializer;
  private final PersistenceConfig.Deserializer deserializer;
  private final PersistenceConfig.GidProvider gidProvider;

  private ImmutablePersistenceConfig(
      DocDB client,
      String repoName,
      String headName,
      PersistenceConfig.AuthorProvider authorProvider,
      PersistenceConfig.Serializer serializer,
      PersistenceConfig.Deserializer deserializer,
      PersistenceConfig.GidProvider gidProvider) {
    this.client = client;
    this.repoName = repoName;
    this.headName = headName;
    this.authorProvider = authorProvider;
    this.serializer = serializer;
    this.deserializer = deserializer;
    this.gidProvider = gidProvider;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public DocDB getClient() {
    return client;
  }

  /**
   * @return The value of the {@code repoName} attribute
   */
  @Override
  public String getRepoName() {
    return repoName;
  }

  /**
   * @return The value of the {@code headName} attribute
   */
  @Override
  public String getHeadName() {
    return headName;
  }

  /**
   * @return The value of the {@code authorProvider} attribute
   */
  @Override
  public PersistenceConfig.AuthorProvider getAuthorProvider() {
    return authorProvider;
  }

  /**
   * @return The value of the {@code serializer} attribute
   */
  @Override
  public PersistenceConfig.Serializer getSerializer() {
    return serializer;
  }

  /**
   * @return The value of the {@code deserializer} attribute
   */
  @Override
  public PersistenceConfig.Deserializer getDeserializer() {
    return deserializer;
  }

  /**
   * @return The value of the {@code gidProvider} attribute
   */
  @Override
  public PersistenceConfig.GidProvider getGidProvider() {
    return gidProvider;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PersistenceConfig#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePersistenceConfig withClient(DocDB value) {
    if (this.client == value) return this;
    DocDB newValue = Objects.requireNonNull(value, "client");
    return new ImmutablePersistenceConfig(
        newValue,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PersistenceConfig#getRepoName() repoName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repoName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePersistenceConfig withRepoName(String value) {
    String newValue = Objects.requireNonNull(value, "repoName");
    if (this.repoName.equals(newValue)) return this;
    return new ImmutablePersistenceConfig(
        this.client,
        newValue,
        this.headName,
        this.authorProvider,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PersistenceConfig#getHeadName() headName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePersistenceConfig withHeadName(String value) {
    String newValue = Objects.requireNonNull(value, "headName");
    if (this.headName.equals(newValue)) return this;
    return new ImmutablePersistenceConfig(
        this.client,
        this.repoName,
        newValue,
        this.authorProvider,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PersistenceConfig#getAuthorProvider() authorProvider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for authorProvider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePersistenceConfig withAuthorProvider(PersistenceConfig.AuthorProvider value) {
    if (this.authorProvider == value) return this;
    PersistenceConfig.AuthorProvider newValue = Objects.requireNonNull(value, "authorProvider");
    return new ImmutablePersistenceConfig(
        this.client,
        this.repoName,
        this.headName,
        newValue,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PersistenceConfig#getSerializer() serializer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serializer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePersistenceConfig withSerializer(PersistenceConfig.Serializer value) {
    if (this.serializer == value) return this;
    PersistenceConfig.Serializer newValue = Objects.requireNonNull(value, "serializer");
    return new ImmutablePersistenceConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        newValue,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PersistenceConfig#getDeserializer() deserializer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deserializer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePersistenceConfig withDeserializer(PersistenceConfig.Deserializer value) {
    if (this.deserializer == value) return this;
    PersistenceConfig.Deserializer newValue = Objects.requireNonNull(value, "deserializer");
    return new ImmutablePersistenceConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.serializer,
        newValue,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PersistenceConfig#getGidProvider() gidProvider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gidProvider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePersistenceConfig withGidProvider(PersistenceConfig.GidProvider value) {
    if (this.gidProvider == value) return this;
    PersistenceConfig.GidProvider newValue = Objects.requireNonNull(value, "gidProvider");
    return new ImmutablePersistenceConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.serializer,
        this.deserializer,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePersistenceConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePersistenceConfig
        && equalTo((ImmutablePersistenceConfig) another);
  }

  private boolean equalTo(ImmutablePersistenceConfig another) {
    return client.equals(another.client)
        && repoName.equals(another.repoName)
        && headName.equals(another.headName)
        && authorProvider.equals(another.authorProvider)
        && serializer.equals(another.serializer)
        && deserializer.equals(another.deserializer)
        && gidProvider.equals(another.gidProvider);
  }

  /**
   * Computes a hash code from attributes: {@code client}, {@code repoName}, {@code headName}, {@code authorProvider}, {@code serializer}, {@code deserializer}, {@code gidProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + client.hashCode();
    h += (h << 5) + repoName.hashCode();
    h += (h << 5) + headName.hashCode();
    h += (h << 5) + authorProvider.hashCode();
    h += (h << 5) + serializer.hashCode();
    h += (h << 5) + deserializer.hashCode();
    h += (h << 5) + gidProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PersistenceConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PersistenceConfig")
        .omitNullValues()
        .add("client", client)
        .add("repoName", repoName)
        .add("headName", headName)
        .add("authorProvider", authorProvider)
        .add("serializer", serializer)
        .add("deserializer", deserializer)
        .add("gidProvider", gidProvider)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link PersistenceConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PersistenceConfig instance
   */
  public static ImmutablePersistenceConfig copyOf(PersistenceConfig instance) {
    if (instance instanceof ImmutablePersistenceConfig) {
      return (ImmutablePersistenceConfig) instance;
    }
    return ImmutablePersistenceConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePersistenceConfig ImmutablePersistenceConfig}.
   * <pre>
   * ImmutablePersistenceConfig.builder()
   *    .client(io.resys.thena.docdb.api.DocDB) // required {@link PersistenceConfig#getClient() client}
   *    .repoName(String) // required {@link PersistenceConfig#getRepoName() repoName}
   *    .headName(String) // required {@link PersistenceConfig#getHeadName() headName}
   *    .authorProvider(io.thestencil.client.spi.PersistenceConfig.AuthorProvider) // required {@link PersistenceConfig#getAuthorProvider() authorProvider}
   *    .serializer(io.thestencil.client.spi.PersistenceConfig.Serializer) // required {@link PersistenceConfig#getSerializer() serializer}
   *    .deserializer(io.thestencil.client.spi.PersistenceConfig.Deserializer) // required {@link PersistenceConfig#getDeserializer() deserializer}
   *    .gidProvider(io.thestencil.client.spi.PersistenceConfig.GidProvider) // required {@link PersistenceConfig#getGidProvider() gidProvider}
   *    .build();
   * </pre>
   * @return A new ImmutablePersistenceConfig builder
   */
  public static ImmutablePersistenceConfig.Builder builder() {
    return new ImmutablePersistenceConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePersistenceConfig ImmutablePersistenceConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PersistenceConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLIENT = 0x1L;
    private static final long INIT_BIT_REPO_NAME = 0x2L;
    private static final long INIT_BIT_HEAD_NAME = 0x4L;
    private static final long INIT_BIT_AUTHOR_PROVIDER = 0x8L;
    private static final long INIT_BIT_SERIALIZER = 0x10L;
    private static final long INIT_BIT_DESERIALIZER = 0x20L;
    private static final long INIT_BIT_GID_PROVIDER = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable DocDB client;
    private @Nullable String repoName;
    private @Nullable String headName;
    private @Nullable PersistenceConfig.AuthorProvider authorProvider;
    private @Nullable PersistenceConfig.Serializer serializer;
    private @Nullable PersistenceConfig.Deserializer deserializer;
    private @Nullable PersistenceConfig.GidProvider gidProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PersistenceConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PersistenceConfig instance) {
      Objects.requireNonNull(instance, "instance");
      client(instance.getClient());
      repoName(instance.getRepoName());
      headName(instance.getHeadName());
      authorProvider(instance.getAuthorProvider());
      serializer(instance.getSerializer());
      deserializer(instance.getDeserializer());
      gidProvider(instance.getGidProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link PersistenceConfig#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder client(DocDB client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Initializes the value for the {@link PersistenceConfig#getRepoName() repoName} attribute.
     * @param repoName The value for repoName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repoName(String repoName) {
      this.repoName = Objects.requireNonNull(repoName, "repoName");
      initBits &= ~INIT_BIT_REPO_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PersistenceConfig#getHeadName() headName} attribute.
     * @param headName The value for headName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headName(String headName) {
      this.headName = Objects.requireNonNull(headName, "headName");
      initBits &= ~INIT_BIT_HEAD_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PersistenceConfig#getAuthorProvider() authorProvider} attribute.
     * @param authorProvider The value for authorProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder authorProvider(PersistenceConfig.AuthorProvider authorProvider) {
      this.authorProvider = Objects.requireNonNull(authorProvider, "authorProvider");
      initBits &= ~INIT_BIT_AUTHOR_PROVIDER;
      return this;
    }

    /**
     * Initializes the value for the {@link PersistenceConfig#getSerializer() serializer} attribute.
     * @param serializer The value for serializer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serializer(PersistenceConfig.Serializer serializer) {
      this.serializer = Objects.requireNonNull(serializer, "serializer");
      initBits &= ~INIT_BIT_SERIALIZER;
      return this;
    }

    /**
     * Initializes the value for the {@link PersistenceConfig#getDeserializer() deserializer} attribute.
     * @param deserializer The value for deserializer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deserializer(PersistenceConfig.Deserializer deserializer) {
      this.deserializer = Objects.requireNonNull(deserializer, "deserializer");
      initBits &= ~INIT_BIT_DESERIALIZER;
      return this;
    }

    /**
     * Initializes the value for the {@link PersistenceConfig#getGidProvider() gidProvider} attribute.
     * @param gidProvider The value for gidProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gidProvider(PersistenceConfig.GidProvider gidProvider) {
      this.gidProvider = Objects.requireNonNull(gidProvider, "gidProvider");
      initBits &= ~INIT_BIT_GID_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePersistenceConfig ImmutablePersistenceConfig}.
     * @return An immutable instance of PersistenceConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePersistenceConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePersistenceConfig(client, repoName, headName, authorProvider, serializer, deserializer, gidProvider);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      if ((initBits & INIT_BIT_REPO_NAME) != 0) attributes.add("repoName");
      if ((initBits & INIT_BIT_HEAD_NAME) != 0) attributes.add("headName");
      if ((initBits & INIT_BIT_AUTHOR_PROVIDER) != 0) attributes.add("authorProvider");
      if ((initBits & INIT_BIT_SERIALIZER) != 0) attributes.add("serializer");
      if ((initBits & INIT_BIT_DESERIALIZER) != 0) attributes.add("deserializer");
      if ((initBits & INIT_BIT_GID_PROVIDER) != 0) attributes.add("gidProvider");
      return "Cannot build PersistenceConfig, some of required attributes are not set " + attributes;
    }
  }
}
