/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.spi.visitor.SiteVisitor;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SiteVisitor.Message", generator="Immutables")
@Immutable
public final class ImmutableMessage
implements SiteVisitor.Message {
    private final String text;
    @Nullable
    private final Object object;

    private ImmutableMessage(String text, @Nullable Object object) {
        this.text = text;
        this.object = object;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.object;
    }

    public final ImmutableMessage withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableMessage(newValue, this.object);
    }

    public final ImmutableMessage withObject(@Nullable Object value) {
        if (this.object == value) {
            return this;
        }
        return new ImmutableMessage(this.text, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessage && this.equalTo((ImmutableMessage)another);
    }

    private boolean equalTo(ImmutableMessage another) {
        return this.text.equals(another.text) && Objects.equals(this.object, another.object);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + Objects.hashCode(this.object);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Message").omitNullValues().add("text", (Object)this.text).add("object", this.object).toString();
    }

    public static ImmutableMessage copyOf(SiteVisitor.Message instance) {
        if (instance instanceof ImmutableMessage) {
            return (ImmutableMessage)instance;
        }
        return ImmutableMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SiteVisitor.Message", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private String text;
        @Nullable
        private Object object;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SiteVisitor.Message instance) {
            Objects.requireNonNull(instance, "instance");
            this.text(instance.getText());
            Object objectValue = instance.getObject();
            if (objectValue != null) {
                this.object(objectValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder object(@Nullable Object object) {
            this.object = object;
            return this;
        }

        public ImmutableMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessage(this.text, this.object);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build Message, some of required attributes are not set " + attributes;
        }
    }
}

