/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import io.thestencil.client.api.StencilClient;
import io.thestencil.staticontent.api.ImmutableLinkResource;
import io.thestencil.staticontent.api.ImmutableMarkdown;
import io.thestencil.staticontent.api.ImmutableMarkdowns;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.visitor.MarkdownException;
import io.thestencil.staticontent.spi.visitor.MarkdownVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SiteStateVisitor {
    public static String LINK_TYPE_WORKFLOW = "workflow";
    private final List<StencilClient.Entity<StencilClient.Locale>> locales = new ArrayList<StencilClient.Entity<StencilClient.Locale>>();
    private StencilClient.SiteState entity;

    public StaticContentClient.Markdowns visit(StencilClient.SiteState entity) {
        this.entity = entity;
        ImmutableMarkdowns.Builder result = ImmutableMarkdowns.builder().addAllLocales(this.visitLocales(entity).stream().map(e -> ((StencilClient.Locale)e.getBody()).getValue()).collect(Collectors.toList()));
        for (StencilClient.Entity article : entity.getArticles().values()) {
            result.addAllValues(this.visitArticle((StencilClient.Entity<StencilClient.Article>)article));
        }
        for (StencilClient.Entity link : entity.getLinks().values()) {
            result.addAllLinks(this.visitLinks((StencilClient.Entity<StencilClient.Link>)link));
        }
        for (StencilClient.Entity link : entity.getWorkflows().values()) {
            result.addAllLinks(this.visitWorkflows((StencilClient.Entity<StencilClient.Workflow>)link));
        }
        return result.build();
    }

    private List<StaticContentClient.LinkResource> visitWorkflows(StencilClient.Entity<StencilClient.Workflow> link) {
        ArrayList<StaticContentClient.LinkResource> result = new ArrayList<StaticContentClient.LinkResource>();
        Optional<StencilClient.Entity> locale = this.locales.stream().filter(l -> ((StencilClient.Workflow)link.getBody()).getLocale().equals(l.getId())).findFirst();
        if (locale.isEmpty()) {
            return result;
        }
        for (String articleId : ((StencilClient.Workflow)link.getBody()).getArticles()) {
            StencilClient.Entity article = (StencilClient.Entity)this.entity.getArticles().get(articleId);
            ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((StencilClient.Locale)locale.get().getBody()).getValue()).addLocale(((StencilClient.Locale)locale.get().getBody()).getValue()).desc(((StencilClient.Workflow)link.getBody()).getName()).path(this.visitArticlePath((StencilClient.Entity<StencilClient.Article>)article)).value(((StencilClient.Workflow)link.getBody()).getContent()).workflow(true).global(false).type(LINK_TYPE_WORKFLOW).build();
            result.add(resource);
        }
        if (((StencilClient.Workflow)link.getBody()).getArticles().isEmpty()) {
            for (StencilClient.Entity article : this.entity.getArticles().values()) {
                ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((StencilClient.Locale)locale.get().getBody()).getValue()).addLocale(((StencilClient.Locale)locale.get().getBody()).getValue()).desc(((StencilClient.Workflow)link.getBody()).getName()).path(this.visitArticlePath((StencilClient.Entity<StencilClient.Article>)article)).value(((StencilClient.Workflow)link.getBody()).getContent()).workflow(true).global(true).type(LINK_TYPE_WORKFLOW).build();
                result.add(resource);
            }
        }
        return result;
    }

    private List<StaticContentClient.LinkResource> visitLinks(StencilClient.Entity<StencilClient.Link> link) {
        ArrayList<StaticContentClient.LinkResource> result = new ArrayList<StaticContentClient.LinkResource>();
        Optional<StencilClient.Entity> locale = this.locales.stream().filter(l -> ((StencilClient.Link)link.getBody()).getLocale().equals(l.getId())).findFirst();
        if (locale.isEmpty()) {
            return result;
        }
        for (String articleId : ((StencilClient.Link)link.getBody()).getArticles()) {
            StencilClient.Entity article = (StencilClient.Entity)this.entity.getArticles().get(articleId);
            ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((StencilClient.Locale)locale.get().getBody()).getValue()).addLocale(((StencilClient.Locale)locale.get().getBody()).getValue()).desc(((StencilClient.Link)link.getBody()).getDescription()).path(this.visitArticlePath((StencilClient.Entity<StencilClient.Article>)article)).value(((StencilClient.Link)link.getBody()).getContent()).workflow(false).global(false).type(((StencilClient.Link)link.getBody()).getContentType()).build();
            result.add(resource);
        }
        if (((StencilClient.Link)link.getBody()).getArticles().isEmpty()) {
            for (StencilClient.Entity article : this.entity.getArticles().values()) {
                ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((StencilClient.Locale)locale.get().getBody()).getValue()).addLocale(((StencilClient.Locale)locale.get().getBody()).getValue()).desc(((StencilClient.Link)link.getBody()).getDescription()).path(this.visitArticlePath((StencilClient.Entity<StencilClient.Article>)article)).value(((StencilClient.Link)link.getBody()).getContent()).workflow(false).global(true).type(((StencilClient.Link)link.getBody()).getContentType()).build();
                result.add(resource);
            }
        }
        return result;
    }

    private List<StaticContentClient.Markdown> visitArticle(StencilClient.Entity<StencilClient.Article> article) {
        String path = this.visitArticlePath(article);
        ArrayList<StaticContentClient.Markdown> result = new ArrayList<StaticContentClient.Markdown>();
        for (StencilClient.Entity page : this.entity.getPages().values()) {
            Optional<StencilClient.Entity> locale;
            if (!((StencilClient.Page)page.getBody()).getArticle().equals(article.getId()) || (locale = this.locales.stream().filter(l -> ((StencilClient.Page)page.getBody()).getLocale().equals(l.getId())).findFirst()).isEmpty()) continue;
            String content = ((StencilClient.Page)page.getBody()).getContent();
            MarkdownVisitor.MarkdownAst ast = new MarkdownVisitor().visit(content);
            if (ast.getHeadings().stream().filter(entity -> entity.getLevel() == 1).findFirst().isEmpty()) {
                throw new MarkdownException("markdown must have atleast one h1(line starting with one # my super menu)");
            }
            result.add(ImmutableMarkdown.builder().path(path).locale(((StencilClient.Locale)locale.get().getBody()).getValue()).value(content).addAllHeadings(ast.getHeadings()).build());
        }
        return result;
    }

    private String visitArticlePath(StencilClient.Entity<StencilClient.Article> src) {
        String parentId;
        StringBuilder path = new StringBuilder();
        StencilClient.Entity<StencilClient.Article> article = src;
        do {
            if (path.length() > 0) {
                path.insert(0, "/");
            }
            path.insert(0, String.format("%03d", ((StencilClient.Article)article.getBody()).getOrder()) + "_" + ((StencilClient.Article)article.getBody()).getName());
        } while ((article = (parentId = ((StencilClient.Article)article.getBody()).getParentId()) == null ? null : (StencilClient.Entity)this.entity.getArticles().get(parentId)) != null);
        return path.toString();
    }

    private List<StencilClient.Entity<StencilClient.Locale>> visitLocales(StencilClient.SiteState site) {
        this.locales.addAll(site.getLocales().values().stream().filter(l -> ((StencilClient.Locale)l.getBody()).getEnabled()).collect(Collectors.toList()));
        return this.locales;
    }
}

