/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.util.HopscotchHashMap;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.marshall.core.ClassIds;
import org.infinispan.marshall.core.ExternallyMarshallable;

class ClassIdentifiers
implements ClassIds {
    private final Map<Class<?>, Integer> classToId = new HopscotchHashMap(255);
    private final Class<?>[] internalIdToClass;

    public static ClassIdentifiers load(GlobalConfiguration globalConfiguration) {
        return new ClassIdentifiers();
    }

    private ClassIdentifiers() {
        this.add(Object.class, 0);
        this.add(String.class, 1);
        this.add(List.class, 2);
        this.add(Map.Entry.class, 3);
        this.add(InternalCacheValue.class, 16);
        this.internalIdToClass = new Class[255];
        this.classToId.entrySet().stream().forEach(e -> {
            this.internalIdToClass[((Integer)e.getValue()).intValue()] = (Class)e.getKey();
        });
    }

    private void add(Class<?> clazz, int id) {
        Integer prev = this.classToId.put(clazz, id);
        assert (prev == null);
    }

    public Class<?> getClass(int id) throws IOException {
        if (id < 0 || id > this.internalIdToClass.length) {
            throw new IOException("Unknown class id " + id);
        }
        Class<?> clazz = this.internalIdToClass[id];
        if (clazz == null) {
            throw new IOException("Unknown class id " + id);
        }
        return clazz;
    }

    public int getId(Class<?> clazz) {
        Integer id = this.classToId.get(clazz);
        if (id == null) {
            assert (ExternallyMarshallable.isAllowed(clazz)) : "Check support for " + clazz;
            return -1;
        }
        return id;
    }
}

