/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.AbstractClusterStats;
import org.infinispan.stats.impl.SecurityActions;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="ClusterCacheStats", description="General cluster statistics such as timings, hit/miss ratio, etc.")
public class ClusterCacheStatsImpl
extends AbstractClusterStats
implements ClusterCacheStats {
    private static String[] LONG_ATTRIBUTES = new String[]{"evictions", "hits", "misses", "offHeapMemoryUsed", "removeHits", "removeMisses", "invalidations", "passivations", "activations", "cacheLoaderLoads", "cacheLoaderMisses", "cacheWriterStores", "stores", "dataMemoryUsed"};
    private static final Log log = LogFactory.getLog(ClusterCacheStatsImpl.class);
    private DefaultExecutorService des;
    private AdvancedCache cache;
    private double readWriteRatio;
    private double hitRatio;

    public ClusterCacheStatsImpl() {
        super(log);
    }

    @Inject
    public void injectDependencies(Cache<?, ?> cache, Configuration configuration) {
        this.cache = cache.getAdvancedCache();
        this.statisticsEnabled = configuration.jmxStatistics().enabled();
    }

    @Override
    @Start
    public void start() {
        this.des = SecurityActions.getDefaultExecutorService(this.cache);
    }

    @Stop
    public void stop() {
        if (this.des != null && !this.des.isShutdown()) {
            this.des.shutdownNow();
        }
    }

    @Override
    void updateStats() throws Exception {
        ArrayList<Map<String, Number>> responseList = new ArrayList<Map<String, Number>>();
        List<CompletableFuture<Map<String, Number>>> responseFutures = this.des.submitEverywhere(new DistributedCacheStatsCallable());
        for (CompletableFuture<Map<String, Number>> cf : responseFutures) {
            responseList.add(cf.get());
        }
        for (String att : LONG_ATTRIBUTES) {
            this.putLongAttributes(responseList, att);
        }
        this.putLongAttributesAverage(responseList, "averageWriteTime");
        this.putLongAttributesAverage(responseList, "averageWriteTimeNanos");
        this.putLongAttributesAverage(responseList, "averageReadTime");
        this.putLongAttributesAverage(responseList, "averageReadTimeNanos");
        this.putLongAttributesAverage(responseList, "averageRemoveTime");
        this.putLongAttributesAverage(responseList, "averageRemoveTimeNanos");
        this.putLongAttributesAverage(responseList, "offHeapMemoryUsed");
        this.putIntAttributes(responseList, "numberOfLocksHeld");
        this.putIntAttributes(responseList, "numberOfLocksAvailable");
        this.putIntAttributesMax(responseList, "minRequiredNodes");
        long numberOfEntriesInMemory = ClusterCacheStatsImpl.getCacheMode(this.cache).isReplicated() ? (long)this.cache.getStats().getCurrentNumberOfEntriesInMemory() : (long)this.addDoubleAttributes(responseList, "numberOfEntriesInMemory");
        this.statsMap.put("numberOfEntriesInMemory", numberOfEntriesInMemory);
        this.statsMap.put("numberOfEntries", this.cache.size());
        this.updateTimeSinceStart(responseList);
        this.updateRatios(responseList);
    }

    @Override
    @ManagedAttribute(description="Cluster wide total average number of milliseconds for a read operation on the cache", displayName="Cluster wide total average read time (ms)", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        return this.getStatAsLong("averageReadTime");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total average number of nanoseconds for a read operation on the cache", displayName="Cluster wide total average read time (ns)", units=Units.NANOSECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTimeNanos() {
        return this.getStatAsLong("averageReadTimeNanos");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total average number of milliseconds for a remove operation in the cache", displayName="Cluster wide total average remove time (ms)", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        return this.getStatAsLong("averageRemoveTime");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total average number of nanoseconds for a remove operation in the cache", displayName="Cluster wide total average remove time (ns)", units=Units.NANOSECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTimeNanos() {
        return this.getStatAsLong("averageRemoveTimeNanos");
    }

    @Override
    @ManagedAttribute(description="Cluster wide average number of milliseconds for a write operation in the cache", displayName="Cluster wide average write time (ms)", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        return this.getStatAsLong("averageWriteTime");
    }

    @Override
    @ManagedAttribute(description="Cluster wide average number of nanoseconds for a write operation in the cache", displayName="Cluster wide average write time (ns)", units=Units.NANOSECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTimeNanos() {
        return this.getStatAsLong("averageWriteTimeNanos");
    }

    @Override
    public int getRequiredMinimumNumberOfNodes() {
        return this.getStatAsInt("minRequiredNodes");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache eviction operations", displayName="Cluster wide total number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        return this.getStatAsLong("evictions");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute hits", displayName="Cluster wide total number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        return this.getStatAsLong("hits");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total percentage hit/(hit+miss) ratio for this cache", displayName="Cluster wide total hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.hitRatio;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute misses", displayName="Cluster wide total number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        return this.getStatAsLong("misses");
    }

    @ManagedAttribute(description="Cluster wide total number of entries currently in the cache, including passivated entries", displayName="Cluster wide total number of current cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        return this.getStatAsInt("numberOfEntries");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of entries currently stored in-memory", displayName="Cluster wide total number of in-memory cache entries", displayType=DisplayType.SUMMARY)
    public int getCurrentNumberOfEntriesInMemory() {
        return this.getStatAsInt("numberOfEntriesInMemory");
    }

    @Override
    @ManagedAttribute(description="Cluster wide read/writes ratio for the cache", displayName="Cluster wide read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.readWriteRatio;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache removal hits", displayName="Cluster wide total number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        return this.getStatAsLong("removeHits");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache removals where keys were not found", displayName="Cluster wide total number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        return this.getStatAsLong("removeMisses");
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute put operations", displayName="Cluster wide total number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        return this.getStatAsLong("stores");
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the first cache node started", displayName="Number of seconds since the first cache node started", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getTimeSinceStart() {
        return this.getStatAsLong("timeSinceStart");
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.getStores();
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of memory used across the cluster for entries in this cache with eviction", displayName="Cluster wide memory used by eviction", displayType=DisplayType.SUMMARY)
    public long getDataMemoryUsed() {
        return this.getStatAsLong("dataMemoryUsed");
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of off-heap memory used across the cluster for this cache", displayName="Cluster wide off-heap memory used", displayType=DisplayType.SUMMARY)
    public long getOffHeapMemoryUsed() {
        return this.getStatAsLong("offHeapMemoryUsed");
    }

    @Override
    public long getRetrievals() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void reset() {
        super.reset();
        this.readWriteRatio = 0.0;
        this.hitRatio = 0.0;
    }

    @Override
    @ManagedAttribute(description="Total number of exclusive locks available in the cluster", displayName="Cluster wide total number of locks", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public int getNumberOfLocksAvailable() {
        return this.getStatAsInt("numberOfLocksAvailable");
    }

    @Override
    @ManagedAttribute(description="Total number of locks held in the cluster", displayName="Cluster wide total number of locks held", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public int getNumberOfLocksHeld() {
        return this.getStatAsInt("numberOfLocksHeld");
    }

    @Override
    @ManagedAttribute(description="The total number of invalidations in the cluster", displayName="Cluster wide total number of invalidations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getInvalidations() {
        return this.getStatAsLong("invalidations");
    }

    @Override
    @ManagedAttribute(description="The total number of activations in the cluster", displayName="Cluster wide total number of activations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getActivations() {
        return this.getStatAsLong("activations");
    }

    @Override
    @ManagedAttribute(description="The total number of passivations in the cluster", displayName="Cluster wide total number of passivations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getPassivations() {
        return this.getStatAsLong("passivations");
    }

    @Override
    @ManagedAttribute(description="The total number of cacheloader load operations in the cluster", displayName="Cluster wide total number of cacheloader loads", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCacheLoaderLoads() {
        return this.getStatAsLong("cacheLoaderLoads");
    }

    @Override
    @ManagedAttribute(description="The total number of cacheloader load misses in the cluster", displayName="Cluster wide total number of cacheloader misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCacheLoaderMisses() {
        return this.getStatAsLong("cacheLoaderMisses");
    }

    @Override
    @ManagedAttribute(description="The total number of cachestore store operations in the cluster", displayName="Cluster wide total number of cachestore stores", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStoreWrites() {
        return this.getStatAsLong("cacheWriterStores");
    }

    private void updateTimeSinceStart(List<Map<String, Number>> responseList) {
        long timeSinceStartMax = 0L;
        for (Map<String, Number> m : responseList) {
            Number timeSinceStart = m.get("timeSinceStart");
            if (timeSinceStart.longValue() <= timeSinceStartMax) continue;
            timeSinceStartMax = timeSinceStart.longValue();
        }
        this.statsMap.put("timeSinceStart", timeSinceStartMax);
    }

    private void updateRatios(List<Map<String, Number>> responseList) {
        long totalHits = 0L;
        long totalRetrievals = 0L;
        long sumOfAllReads = 0L;
        long sumOfAllWrites = 0L;
        for (Map<String, Number> m : responseList) {
            long hits = m.get("hits").longValue();
            long misses = m.get("misses").longValue();
            sumOfAllReads += (totalHits += hits) + misses;
            sumOfAllWrites += m.get("stores").longValue();
            totalRetrievals += hits + misses;
        }
        this.hitRatio = totalRetrievals > 0L ? (double)totalHits / (double)totalRetrievals : 0.0;
        this.readWriteRatio = sumOfAllWrites > 0L ? (double)sumOfAllReads / (double)sumOfAllWrites : 0.0;
    }

    private static <T extends AsyncInterceptor> T getFirstInterceptorWhichExtends(AdvancedCache<?, ?> cache, Class<T> interceptorClass) {
        return (T)((AsyncInterceptor)interceptorClass.cast(cache.getAsyncInterceptorChain().findInterceptorExtending(interceptorClass)));
    }

    private static CacheMode getCacheMode(Cache cache) {
        return cache.getCacheConfiguration().clustering().cacheMode();
    }

    private static class DistributedCacheStatsCallable
    implements DistributedCallable<Object, Object, Map<String, Number>>,
    Serializable {
        private static final long serialVersionUID = -8400973931071456798L;
        private transient AdvancedCache<Object, Object> remoteCache;

        private DistributedCacheStatsCallable() {
        }

        @Override
        public Map<String, Number> call() throws Exception {
            HashMap<String, Number> map = new HashMap<String, Number>();
            Stats stats = this.remoteCache.getStats();
            map.put("averageReadTime", stats.getAverageReadTime());
            map.put("averageReadTimeNanos", stats.getAverageReadTimeNanos());
            map.put("averageWriteTime", stats.getAverageWriteTime());
            map.put("averageWriteTimeNanos", stats.getAverageWriteTimeNanos());
            map.put("averageRemoveTime", stats.getAverageRemoveTime());
            map.put("averageRemoveTimeNanos", stats.getAverageRemoveTimeNanos());
            map.put("evictions", stats.getEvictions());
            map.put("hits", stats.getHits());
            map.put("misses", stats.getMisses());
            if (!ClusterCacheStatsImpl.getCacheMode(this.remoteCache).isReplicated()) {
                double numberOfEntriesInMemory = stats.getCurrentNumberOfEntriesInMemory();
                map.put("numberOfEntriesInMemory", numberOfEntriesInMemory /= (double)this.remoteCache.getCacheConfiguration().clustering().hash().numOwners());
            }
            map.put("dataMemoryUsed", stats.getDataMemoryUsed());
            map.put("offHeapMemoryUsed", stats.getOffHeapMemoryUsed());
            map.put("minRequiredNodes", stats.getRequiredMinimumNumberOfNodes());
            map.put("stores", stats.getStores());
            map.put("removeHits", stats.getRemoveHits());
            map.put("removeMisses", stats.getRemoveMisses());
            map.put("timeSinceStart", stats.getTimeSinceStart());
            LockManager lockManager = this.remoteCache.getLockManager();
            map.put("numberOfLocksHeld", lockManager.getNumberOfLocksHeld());
            map.put("numberOfLocksAvailable", 0);
            InvalidationInterceptor invalidationInterceptor = (InvalidationInterceptor)ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, InvalidationInterceptor.class);
            if (invalidationInterceptor != null) {
                map.put("invalidations", invalidationInterceptor.getInvalidations());
            } else {
                map.put("invalidations", 0);
            }
            PassivationManager pManager = this.remoteCache.getComponentRegistry().getComponent(PassivationManager.class);
            if (pManager != null) {
                map.put("passivations", pManager.getPassivations());
            } else {
                map.put("passivations", 0);
            }
            ActivationManager aManager = this.remoteCache.getComponentRegistry().getComponent(ActivationManager.class);
            if (aManager != null) {
                map.put("activations", aManager.getActivationCount());
            } else {
                map.put("activations", 0);
            }
            CacheLoaderInterceptor aInterceptor = (CacheLoaderInterceptor)ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, CacheLoaderInterceptor.class);
            if (aInterceptor != null) {
                map.put("cacheLoaderLoads", aInterceptor.getCacheLoaderLoads());
                map.put("cacheLoaderMisses", aInterceptor.getCacheLoaderMisses());
            } else {
                map.put("cacheLoaderLoads", 0);
                map.put("cacheLoaderMisses", 0);
            }
            CacheWriterInterceptor interceptor = (CacheWriterInterceptor)ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, CacheWriterInterceptor.class);
            if (interceptor != null) {
                map.put("cacheWriterStores", interceptor.getWritesToTheStores());
            } else {
                map.put("cacheWriterStores", 0);
            }
            return map;
        }

        @Override
        public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
            this.remoteCache = cache.getAdvancedCache();
        }
    }
}

