/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal.logging;

import io.agroal.api.AgroalDataSource;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.datasources.agroal.logging.AgroalLogger;

public class AgroalLogger_$logger
extends DelegatingBasicLogger
implements AgroalLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AgroalLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String addingDeploymentProcessors = "WFLYAG0001: Adding deployment processors for DataSourceDefinition annotation and resource-ref entries";
    private static final String startedDataSource = "WFLYAG0101: Started datasource '%s' bound to [%s]";
    private static final String stoppedDataSource = "WFLYAG0102: Stopped datasource '%s'";
    private static final String startedXADataSource = "WFLYAG0103: Started xa-datasource '%s' bound to [%s]";
    private static final String stoppedXADataSource = "WFLYAG0104: Stopped xa-datasource '%s'";
    private static final String datasourceStartException = "WFLYAG0105: Exception starting datasource '%s'";
    private static final String xaDatasourceStartException = "WFLYAG0106: Exception starting xa-datasource '%s'";
    private static final String invalidConnectionProvider = "WFLYAG0107: Invalid connection provider. Either a java.sql.Driver or javax.sql.DataSource implementation is required. Fix the connection-provider for the driver";
    private static final String invalidXAConnectionProvider = "WFLYAG0108: An xa-datasource requires a javax.sql.XADataSource as connection provider. Fix the connection-provider for the driver";
    private static final String missingTransactionManager = "WFLYAG0109: Could not start datasource: transaction manager is missing";
    private static final String invalidAuthentication = "WFLYAG0110: Error obtaining credentials from authentication context for datasource '%s'";
    private static final String invalidCredentialSourceSupplier = "WFLYAG0111: CredentialSourceSupplier for datasource '%s' is invalid";
    private static final String flushOperation = "WFLYAG0201: Performing flush operation, mode %s";
    private static final String unknownDatasourceServiceType = "WFLYAG0301: Unknown datasource service of type: %s";
    private static final String invalidConnection = "WFLYAG0302: Invalid connection in '%s'";
    private static final String jndiNameInvalidFormat = "WFLYAG0303: JNDI name have to start with java:/ or java:jboss/";
    private static final String jndiNameShouldValidate = "WFLYAG0304: JNDI name shouldn't include '//' or end with '/'";
    private static final String invalidDeploymentConnectionProvider = "WFLYAG0401: Invalid connection provider. Either a java.sql.Driver or javax.sql.DataSource implementation is required. Fix the connection-provider for the driver";
    private static final String loadClassDeploymentException = "WFLYAG0402: Failed to load connection provider class '%s'";
    private static final String missingAttributeInDatasourceMetadata = "WFLYAG0403: Element <data-source> must provide attribute '%s'";
    private static final String driverLoaded = "WFLYAG0501: Loaded class %s for driver '%s'";
    private static final String loadModuleException = "WFLYAG0502: Failed to load driver module '%s'";
    private static final String loadClassException = "WFLYAG0503: Failed to load driver class '%s'";
    private static final String poolWarning = "WFLYAG0601: %s: %s";

    public AgroalLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void addingDeploymentProcessors() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.addingDeploymentProcessors$str(), new Object[0]);
    }

    protected String addingDeploymentProcessors$str() {
        return addingDeploymentProcessors;
    }

    @Override
    public final void startedDataSource(String datasource, String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startedDataSource$str(), (Object)datasource, (Object)jndiName);
    }

    protected String startedDataSource$str() {
        return startedDataSource;
    }

    @Override
    public final void stoppedDataSource(String datasource) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppedDataSource$str(), (Object)datasource);
    }

    protected String stoppedDataSource$str() {
        return stoppedDataSource;
    }

    @Override
    public final void startedXADataSource(String datasource, String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startedXADataSource$str(), (Object)datasource, (Object)jndiName);
    }

    protected String startedXADataSource$str() {
        return startedXADataSource;
    }

    @Override
    public final void stoppedXADataSource(String datasource) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppedXADataSource$str(), (Object)datasource);
    }

    protected String stoppedXADataSource$str() {
        return stoppedXADataSource;
    }

    protected String datasourceStartException$str() {
        return datasourceStartException;
    }

    @Override
    public final StartException datasourceStartException(SQLException cause, String dataSourceName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.datasourceStartException$str(), dataSourceName), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String xaDatasourceStartException$str() {
        return xaDatasourceStartException;
    }

    @Override
    public final StartException xaDatasourceStartException(SQLException cause, String dataSourceName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.xaDatasourceStartException$str(), dataSourceName), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnectionProvider$str() {
        return invalidConnectionProvider;
    }

    @Override
    public final StartException invalidConnectionProvider() {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidConnectionProvider$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidXAConnectionProvider$str() {
        return invalidXAConnectionProvider;
    }

    @Override
    public final StartException invalidXAConnectionProvider() {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidXAConnectionProvider$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingTransactionManager$str() {
        return missingTransactionManager;
    }

    @Override
    public final StartException missingTransactionManager() {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.missingTransactionManager$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAuthentication$str() {
        return invalidAuthentication;
    }

    @Override
    public final StartException invalidAuthentication(Throwable cause, String dataSourceName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidAuthentication$str(), dataSourceName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCredentialSourceSupplier$str() {
        return invalidCredentialSourceSupplier;
    }

    @Override
    public final StartException invalidCredentialSourceSupplier(Throwable cause, String dataSourceName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidCredentialSourceSupplier$str(), dataSourceName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void flushOperation(AgroalDataSource.FlushMode mode) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.flushOperation$str(), (Object)mode);
    }

    protected String flushOperation$str() {
        return flushOperation;
    }

    protected String unknownDatasourceServiceType$str() {
        return unknownDatasourceServiceType;
    }

    @Override
    public final OperationFailedException unknownDatasourceServiceType(String serviceType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unknownDatasourceServiceType$str(), serviceType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnection$str() {
        return invalidConnection;
    }

    @Override
    public final OperationFailedException invalidConnection(SQLException cause, String dataSourceName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidConnection$str(), dataSourceName), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jndiNameInvalidFormat$str() {
        return jndiNameInvalidFormat;
    }

    @Override
    public final OperationFailedException jndiNameInvalidFormat() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.jndiNameInvalidFormat$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jndiNameShouldValidate$str() {
        return jndiNameShouldValidate;
    }

    @Override
    public final OperationFailedException jndiNameShouldValidate() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.jndiNameShouldValidate$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDeploymentConnectionProvider$str() {
        return invalidDeploymentConnectionProvider;
    }

    @Override
    public final DeploymentUnitProcessingException invalidDeploymentConnectionProvider() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidDeploymentConnectionProvider$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String loadClassDeploymentException$str() {
        return loadClassDeploymentException;
    }

    @Override
    public final DeploymentUnitProcessingException loadClassDeploymentException(Throwable cause, String className) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.loadClassDeploymentException$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingAttributeInDatasourceMetadata$str() {
        return missingAttributeInDatasourceMetadata;
    }

    @Override
    public final DeploymentUnitProcessingException missingAttributeInDatasourceMetadata(String attributeName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.missingAttributeInDatasourceMetadata$str(), attributeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void driverLoaded(String className, String driverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.driverLoaded$str(), (Object)className, (Object)driverName);
    }

    protected String driverLoaded$str() {
        return driverLoaded;
    }

    protected String loadModuleException$str() {
        return loadModuleException;
    }

    @Override
    public final IllegalArgumentException loadModuleException(Throwable cause, String moduleName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.loadModuleException$str(), moduleName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String loadClassException$str() {
        return loadClassException;
    }

    @Override
    public final IllegalArgumentException loadClassException(Throwable cause, String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.loadClassException$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void poolWarning(String datasourceName, String warn) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.poolWarning$str(), (Object)datasourceName, (Object)warn);
    }

    protected String poolWarning$str() {
        return poolWarning;
    }
}

