/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.ImplicitConverters;
import io.smallrye.config.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    private final List<ConfigSource> configSources;
    private final Map<Type, Converter<?>> converters;

    protected SmallRyeConfig(List<ConfigSource> configSources, Map<Type, Converter<?>> converters) {
        this.configSources = configSources;
        this.converters = new HashMap(Converters.ALL_CONVERTERS);
        this.converters.putAll(converters);
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            if (value.isEmpty()) break;
            String[] itemStrings = StringUtil.split(value);
            Collection collection = (Collection)collectionFactory.apply(itemStrings.length);
            for (String itemString : itemStrings) {
                collection.add(this.convert(itemString, itemClass));
            }
            return (C)collection;
        }
        return (C)((Collection)collectionFactory.apply(0));
    }

    public <T> T getValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            if (value.isEmpty()) break;
            return this.convert(value, aClass);
        }
        if (aClass.isAssignableFrom(OptionalInt.class)) {
            return aClass.cast(OptionalInt.empty());
        }
        if (aClass.isAssignableFrom(OptionalLong.class)) {
            return aClass.cast(OptionalLong.empty());
        }
        if (aClass.isAssignableFrom(OptionalDouble.class)) {
            return aClass.cast(OptionalDouble.empty());
        }
        throw new NoSuchElementException("Property " + name + " not found");
    }

    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            return value.isEmpty() ? Optional.empty() : Optional.of(this.convert(value, aClass));
        }
        return Optional.empty();
    }

    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        for (ConfigSource configSource : this.configSources) {
            names.addAll(configSource.getProperties().keySet());
        }
        return names;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.configSources;
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value != null) {
            boolean isArray = asType.isArray();
            if (isArray) {
                String[] split = StringUtil.split(value);
                Class<?> componentType = asType.getComponentType();
                T array = asType.cast(Array.newInstance(componentType, split.length));
                for (int i = 0; i < split.length; ++i) {
                    Array.set(array, i, this.convert(split[i], componentType));
                }
                return array;
            }
            Converter<T> converter = this.getConverter(asType);
            return (T)converter.convert(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Converter<T> getConverter(Class<T> asType) {
        Object converter = this.converters.get(asType);
        if (converter == null) {
            Map<Type, Converter<?>> map = this.converters;
            synchronized (map) {
                converter = ImplicitConverters.getConverter(asType);
                this.converters.putIfAbsent(asType, (Converter<?>)converter);
            }
        }
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }
}

