/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.marshalling.FieldSetter;
import org.wildfly.common.Assert;

public final class EJBMethodLocator
implements Serializable {
    private static final long serialVersionUID = -1387266421025030533L;
    private final String methodName;
    private final String[] parameterTypeNames;
    private final transient int hashCode;
    private static final FieldSetter hashCodeSetter = FieldSetter.get(EJBMethodLocator.class, "hashCode");

    public EJBMethodLocator(String methodName, String ... parameterTypeNames) {
        this(methodName, parameterTypeNames, true);
    }

    private EJBMethodLocator(String methodName, String[] parameterTypeNames, boolean copy) {
        Assert.checkNotNullParam("methodName", methodName);
        Assert.checkNotNullParam("parameterTypeNames", parameterTypeNames);
        this.methodName = methodName;
        int length = parameterTypeNames.length;
        this.parameterTypeNames = copy && length > 0 ? (String[])parameterTypeNames.clone() : parameterTypeNames;
        String[] clone = this.parameterTypeNames;
        for (int i = 0; i < length; ++i) {
            Assert.checkNotNullArrayParam("parameterTypeNames", i, clone[i]);
        }
        this.hashCode = EJBMethodLocator.calcHashCode(methodName, parameterTypeNames);
    }

    public static EJBMethodLocator forMethod(Method method) {
        Assert.checkNotNullParam("method", method);
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int length = parameterTypes.length;
        String[] paramNames = new String[length];
        for (int i = 0; i < length; ++i) {
            paramNames[i] = parameterTypes[i].getName();
        }
        return new EJBMethodLocator(name, paramNames, false);
    }

    private static int calcHashCode(String methodName, String[] parameterTypeNames) {
        return methodName.hashCode() + 13 * Arrays.hashCode(parameterTypeNames);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getParameterCount() {
        return this.parameterTypeNames.length;
    }

    public String getParameterTypeName(int index) {
        return this.parameterTypeNames[index];
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        Assert.checkNotNullParam("methodName", this.methodName);
        Assert.checkNotNullParam("parameterTypeNames", this.parameterTypeNames);
        for (int i = 0; i < this.parameterTypeNames.length; ++i) {
            Assert.checkNotNullArrayParam("parameterTypeNames", i, this.parameterTypeNames[i]);
        }
        hashCodeSetter.setInt(this, EJBMethodLocator.calcHashCode(this.methodName, this.parameterTypeNames));
    }

    public boolean equals(Object other) {
        return other instanceof EJBMethodLocator && this.equals((EJBMethodLocator)other);
    }

    public boolean equals(EJBMethodLocator other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.methodName.equals(other.methodName) && Arrays.equals(this.parameterTypeNames, other.parameterTypeNames);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

