/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.mail.extension.MailExtension;
import org.jboss.as.mail.extension.MailServerAdd;
import org.jboss.as.mail.extension.MailServerWriteAttributeHandler;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.MailSubsystemModel;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

class MailServerDefinition
extends PersistentResourceDefinition {
    static final String OUTBOUND_SOCKET_BINDING_CAPABILITY_NAME = "org.wildfly.network.outbound-socket-binding";
    static final String CREDENTIAL_STORE_CAPABILITY = "org.wildfly.security.credential-store";
    static final RuntimeCapability<Void> SERVER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.mail.session.server", (boolean)true).setDynamicNameMapper(DynamicNameMappers.PARENT).build();
    static final SensitivityClassification MAIL_SERVER_SECURITY = new SensitivityClassification("mail", "mail-server-security", false, false, true);
    static final SensitiveTargetAccessConstraintDefinition MAIL_SERVER_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(MAIL_SERVER_SECURITY);
    static final SimpleAttributeDefinition OUTBOUND_SOCKET_BINDING_REF = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("outbound-socket-binding-ref", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    static final SimpleAttributeDefinition OUTBOUND_SOCKET_BINDING_REF_OPTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)OUTBOUND_SOCKET_BINDING_REF).setCapabilityReference("org.wildfly.network.outbound-socket-binding")).setRequired(false)).build();
    protected static final SimpleAttributeDefinition SSL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl", ModelType.BOOLEAN, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(false))).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).build();
    protected static final SimpleAttributeDefinition TLS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("tls", ModelType.BOOLEAN, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(false))).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).build();
    protected static final SimpleAttributeDefinition USERNAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("username", ModelType.STRING, true).setAllowExpression(true)).setXmlName("username")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((boolean)true, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).addAlternatives(new String[]{"password"})).setCapabilityReference("org.wildfly.security.credential-store")).build();
    protected static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).setAlternatives(new String[]{"credential-reference"})).build();
    static final PropertiesAttributeDefinition PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("properties", true).setAttributeMarshaller(AttributeMarshaller.PROPERTIES_MARSHALLER_UNWRAPPED)).setAttributeParser(AttributeParser.PROPERTIES_PARSER_UNWRAPPED)).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{OUTBOUND_SOCKET_BINDING_REF, SSL, TLS, USERNAME, PASSWORD, CREDENTIAL_REFERENCE};
    static final AttributeDefinition[] ATTRIBUTES_CUSTOM = new AttributeDefinition[]{OUTBOUND_SOCKET_BINDING_REF_OPTIONAL, SSL, TLS, USERNAME, PASSWORD, CREDENTIAL_REFERENCE, PROPERTIES};
    static final MailServerDefinition INSTANCE_SMTP = new MailServerDefinition(MailSubsystemModel.SMTP_SERVER_PATH, ATTRIBUTES);
    static final MailServerDefinition INSTANCE_IMAP = new MailServerDefinition(MailSubsystemModel.IMAP_SERVER_PATH, ATTRIBUTES);
    static final MailServerDefinition INSTANCE_POP3 = new MailServerDefinition(MailSubsystemModel.POP3_SERVER_PATH, ATTRIBUTES);
    static final MailServerDefinition INSTANCE_CUSTOM = new MailServerDefinition(MailSubsystemModel.CUSTOM_SERVER_PATH, ATTRIBUTES_CUSTOM);
    private final List<AttributeDefinition> attributes;

    private MailServerDefinition(PathElement path, AttributeDefinition[] attributes) {
        super(new PersistentResourceDefinition.Parameters(path, (ResourceDescriptionResolver)MailExtension.getResourceDescriptionResolver("mail-session", "server")).setAddHandler((OperationStepHandler)new MailServerAdd(attributes)).setRemoveHandler((OperationStepHandler)new MailServerRemove(attributes)).setCapabilities(new RuntimeCapability[]{SERVER_CAPABILITY}));
        this.attributes = Arrays.asList(attributes);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        MailServerWriteAttributeHandler handler = new MailServerWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attr : this.getAttributes()) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    private static final class MailServerRemove
    extends RestartParentResourceRemoveHandler {
        private final AttributeDefinition[] attributes;

        private MailServerRemove(AttributeDefinition ... attributes) {
            super("mail-session");
            this.attributes = attributes;
        }

        protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource r = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            super.updateModel(context, operation);
            this.recordCapabilitiesAndRequirements(context, r);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            MailSessionAdd.installRuntimeServices(context, parentAddress, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MailSessionDefinition.SESSION_CAPABILITY.getCapabilityServiceName(new String[]{parentAddress.getLastElement().getValue()});
        }

        protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
            super.removeServices(context, parentService, parentModel);
            String jndiName = MailSessionAdd.getJndiName(parentModel, context);
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            context.removeService(bindInfo.getBinderServiceName());
        }

        private void recordCapabilitiesAndRequirements(OperationContext context, Resource resource) throws OperationFailedException {
            context.deregisterCapability(SERVER_CAPABILITY.getDynamicName(context.getCurrentAddress()));
            ModelNode model = resource.getModel();
            for (AttributeDefinition ad : this.attributes) {
                if (ad == null || !model.hasDefined(ad.getName()) && !ad.hasCapabilityRequirements()) continue;
                ad.removeCapabilityRequirements(context, resource, model.get(ad.getName()));
            }
        }
    }
}

