/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AuditLogLoggerResourceDefinition;
import org.jboss.as.domain.management.audit.EnvironmentNameReader;
import org.jboss.as.domain.management.audit.FileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.InMemoryAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.JsonAuditLogFormatterResourceDefinition;
import org.jboss.as.domain.management.audit.PeriodicRotatingFileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.SizeRotatingFileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.SyslogAuditLogHandlerResourceDefinition;

public class AccessAuditResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"access", (String)"audit");
    static final String DEPRECATED_MESSAGE_CATEGORY = "core.management.audit-log";
    private final ManagedAuditLogger auditLogger;
    private final PathManagerService pathManager;
    private final EnvironmentNameReader environmentReader;

    public AccessAuditResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver(DEPRECATED_MESSAGE_CATEGORY), (OperationStepHandler)new AbstractAddStepHandler(){

            protected boolean requiresRuntime(OperationContext context) {
                return false;
            }
        }, (OperationStepHandler)new AbstractRemoveStepHandler(){

            protected boolean requiresRuntime(OperationContext context) {
                return false;
            }
        });
        this.auditLogger = auditLogger;
        this.pathManager = pathManager;
        this.environmentReader = environmentReader;
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new JsonAuditLogFormatterResourceDefinition(this.auditLogger));
        resourceRegistration.registerSubModel((ResourceDefinition)new FileAuditLogHandlerResourceDefinition(this.auditLogger, this.pathManager));
        resourceRegistration.registerSubModel((ResourceDefinition)new PeriodicRotatingFileAuditLogHandlerResourceDefinition(this.auditLogger, this.pathManager));
        resourceRegistration.registerSubModel((ResourceDefinition)new SizeRotatingFileAuditLogHandlerResourceDefinition(this.auditLogger, this.pathManager));
        resourceRegistration.registerSubModel((ResourceDefinition)new SyslogAuditLogHandlerResourceDefinition(this.auditLogger, this.pathManager, this.environmentReader));
        resourceRegistration.registerSubModel((ResourceDefinition)new InMemoryAuditLogHandlerResourceDefinition(this.auditLogger));
        resourceRegistration.registerSubModel((ResourceDefinition)AuditLogLoggerResourceDefinition.createDefinition(this.auditLogger));
        if (!this.environmentReader.isServer()) {
            resourceRegistration.registerSubModel((ResourceDefinition)AuditLogLoggerResourceDefinition.createHostServerDefinition());
        }
    }
}

