/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.AcceptorControlHandler;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;

public abstract class AbstractTransportDefinition
extends PersistentResourceDefinition {
    private final boolean registerRuntimeOnly;
    private final AttributeDefinition[] attrs;
    protected final boolean isAcceptor;

    protected AbstractTransportDefinition(boolean isAcceptor, final String specificType, boolean registerRuntimeOnly, AttributeDefinition ... attrs) {
        super(new PersistentResourceDefinition.Parameters(PathElement.pathElement((String)specificType), (ResourceDescriptionResolver)new StandardResourceDescriptionResolver(isAcceptor ? "acceptor" : "connector", MessagingExtension.RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, false){

            public String getResourceDescription(Locale locale, ResourceBundle bundle) {
                return bundle.getString(specificType);
            }
        }).setAddHandler((OperationStepHandler)new ActiveMQReloadRequiredHandlers.AddStepHandler(attrs)).setRemoveHandler((OperationStepHandler)new ActiveMQReloadRequiredHandlers.RemoveStepHandler()));
        this.isAcceptor = isAcceptor;
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.attrs = attrs;
    }

    protected AbstractTransportDefinition(boolean isAcceptor, final String specificType, boolean registerRuntimeOnly, ModelVersion deprecatedSince, AttributeDefinition ... attrs) {
        super(new PersistentResourceDefinition.Parameters(PathElement.pathElement((String)specificType), (ResourceDescriptionResolver)new StandardResourceDescriptionResolver(isAcceptor ? "acceptor" : "connector", MessagingExtension.RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, false){

            public String getResourceDescription(Locale locale, ResourceBundle bundle) {
                return bundle.getString(specificType);
            }
        }).setAddHandler((OperationStepHandler)new ActiveMQReloadRequiredHandlers.AddStepHandler(attrs)).setRemoveHandler((OperationStepHandler)new ActiveMQReloadRequiredHandlers.RemoveStepHandler()).setDeprecatedSince(deprecatedSince));
        this.isAcceptor = isAcceptor;
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.attrs = attrs;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(this.attrs);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ReloadRequiredWriteAttributeHandler attributeHandler = new ReloadRequiredWriteAttributeHandler(this.attrs);
        for (AttributeDefinition attr : this.attrs) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)attributeHandler);
        }
        if (this.isAcceptor) {
            AcceptorControlHandler.INSTANCE.registerAttributes(registry);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        if (this.isAcceptor && this.registerRuntimeOnly) {
            AcceptorControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
        }
        super.registerOperations(registry);
    }
}

