/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import javax.transaction.TransactionManager;
import org.apache.activemq.artemis.jms.bridge.JMSBridge;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.transaction.client.ContextTransactionManager;

class JMSBridgeService
implements Service<JMSBridge> {
    private final JMSBridge bridge;
    private final String bridgeName;
    private final String moduleName;
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> sourceCredentialSourceSupplierInjector = new InjectedValue();
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> targetCredentialSourceSupplierInjector = new InjectedValue();

    public JMSBridgeService(String moduleName, String bridgeName, JMSBridge bridge) {
        if (bridge == null) {
            throw MessagingLogger.ROOT_LOGGER.nullVar("bridge");
        }
        this.moduleName = moduleName;
        this.bridgeName = bridgeName;
        this.bridge = bridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSBridgeService.this.bridge.setTransactionManager((TransactionManager)ContextTransactionManager.getInstance());
                    JMSBridgeService.this.startBridge();
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingLogger.ROOT_LOGGER.failedToCreate(e, "JMS Bridge"));
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public void startBridge() throws Exception {
        Module module;
        if (this.moduleName != null) {
            ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)this.moduleName);
            module = Module.getContextModuleLoader().loadModule(moduleID);
        } else {
            module = Module.forClass(JMSBridgeService.class);
        }
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            this.setJMSBridgePasswordsFromCredentialSource();
            this.bridge.start();
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
        MessagingLogger.ROOT_LOGGER.startedService("JMS Bridge", this.bridgeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSBridgeService.this.bridge.stop();
                    MessagingLogger.ROOT_LOGGER.stoppedService("JMS Bridge", JMSBridgeService.this.bridgeName);
                    context.complete();
                }
                catch (Exception e) {
                    MessagingLogger.ROOT_LOGGER.failedToDestroy("JMS Bridge", JMSBridgeService.this.bridgeName);
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public JMSBridge getValue() throws IllegalStateException {
        return this.bridge;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }

    public InjectedValue<ExceptionSupplier<CredentialSource, Exception>> getSourceCredentialSourceSupplierInjector() {
        return this.sourceCredentialSourceSupplierInjector;
    }

    public InjectedValue<ExceptionSupplier<CredentialSource, Exception>> getTargetCredentialSourceSupplierInjector() {
        return this.targetCredentialSourceSupplierInjector;
    }

    private void setJMSBridgePasswordsFromCredentialSource() {
        this.setNewJMSBridgePassword((ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)this.sourceCredentialSourceSupplierInjector.getOptionalValue()), arg_0 -> ((JMSBridge)this.bridge).setSourcePassword(arg_0));
        this.setNewJMSBridgePassword((ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)this.targetCredentialSourceSupplierInjector.getOptionalValue()), arg_0 -> ((JMSBridge)this.bridge).setTargetPassword(arg_0));
    }

    private void setNewJMSBridgePassword(ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier, Consumer<String> passwordConsumer) {
        if (credentialSourceSupplier != null) {
            try {
                char[] password;
                CredentialSource credentialSource = (CredentialSource)credentialSourceSupplier.get();
                if (credentialSource != null && (password = ((ClearPassword)((PasswordCredential)credentialSource.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword()) != null) {
                    passwordConsumer.accept(new String(password));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

