/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism._private;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;

public final class MechanismUtil {
    private MechanismUtil() {
    }

    public static <S extends Password> S getPasswordCredential(String userName, CallbackHandler callbackHandler, Class<S> passwordType, String passwordAlgorithm, AlgorithmParameterSpec matchParameters, AlgorithmParameterSpec generateParameters, Supplier<Provider[]> providers, ElytronMessages log) throws AuthenticationMechanismException {
        Assert.checkNotNullParam("userName", userName);
        Assert.checkNotNullParam("callbackHandler", callbackHandler);
        Assert.checkNotNullParam("passwordType", passwordType);
        Assert.checkNotNullParam("passwordAlgorithm", passwordAlgorithm);
        Assert.checkNotNullParam("providers", providers);
        try {
            PasswordFactory passwordFactory;
            block16: {
                passwordFactory = PasswordFactory.getInstance(passwordAlgorithm, providers);
                CredentialCallback credentialCallback = new CredentialCallback(PasswordCredential.class, passwordAlgorithm, matchParameters);
                try {
                    MechanismUtil.handleCallbacks(log, callbackHandler, credentialCallback);
                    Password password = credentialCallback.applyToCredential(PasswordCredential.class, c -> c.getPassword(passwordType));
                    if (password != null) {
                        return (S)(matchParameters != null ? (Password)passwordType.cast(passwordFactory.transform(password, matchParameters)) : password);
                    }
                }
                catch (UnsupportedCallbackException e) {
                    if (e.getCallback() != credentialCallback) {
                        throw log.mechCallbackHandlerFailedForUnknownReason(e);
                    }
                }
                catch (ClassCastException | InvalidAlgorithmParameterException e) {
                    // empty catch block
                }
                credentialCallback = new CredentialCallback(PasswordCredential.class, "clear");
                try {
                    MechanismUtil.handleCallbacks(log, callbackHandler, credentialCallback);
                    TwoWayPassword twoWayPassword = credentialCallback.applyToCredential(PasswordCredential.class, c -> c.getPassword(TwoWayPassword.class));
                    if (twoWayPassword != null) {
                        PasswordFactory clearFactory = PasswordFactory.getInstance(twoWayPassword.getAlgorithm(), providers);
                        ClearPasswordSpec spec = clearFactory.getKeySpec(clearFactory.translate(twoWayPassword), ClearPasswordSpec.class);
                        if (matchParameters != null) {
                            return (S)((Password)passwordType.cast(passwordFactory.generatePassword(new EncryptablePasswordSpec(spec.getEncodedPassword(), generateParameters))));
                        }
                        return (S)((Password)passwordType.cast(passwordFactory.generatePassword(spec)));
                    }
                }
                catch (UnsupportedCallbackException e) {
                    if (e.getCallback() == credentialCallback) break block16;
                    throw log.mechCallbackHandlerFailedForUnknownReason(e);
                }
            }
            PasswordCallback passwordCallback = new PasswordCallback("User password", false);
            try {
                MechanismUtil.handleCallbacks(log, callbackHandler, passwordCallback);
                char[] password = passwordCallback.getPassword();
                if (password != null) {
                    if (matchParameters != null) {
                        return (S)((Password)passwordType.cast(passwordFactory.generatePassword(new EncryptablePasswordSpec(password, generateParameters))));
                    }
                    return (S)((Password)passwordType.cast(passwordFactory.generatePassword(new ClearPasswordSpec(password))));
                }
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() != passwordCallback) {
                    throw log.mechCallbackHandlerFailedForUnknownReason(e);
                }
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw log.mechCallbackHandlerDoesNotSupportCredentialAcquisition(e);
        }
        throw log.mechUnableToRetrievePassword(userName);
    }

    public static void handleCallbacks(ElytronMessages log, CallbackHandler callbackHandler, Callback ... callbacks) throws AuthenticationMechanismException, UnsupportedCallbackException {
        try {
            callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException | AuthenticationMechanismException e) {
            throw e;
        }
        catch (Throwable e) {
            throw log.mechCallbackHandlerFailedForUnknownReason(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R computeIfAbsent(HttpScope scope, String key, Function<String, R> mappingFunction) {
        Assert.checkNotNullParam("scope", scope);
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("mappingFunction", mappingFunction);
        HttpScope httpScope = scope;
        synchronized (httpScope) {
            Object existing;
            if (!scope.exists()) {
                scope.create();
            }
            if ((existing = scope.getAttachment(key)) == null) {
                R newValue = mappingFunction.apply(key);
                Assert.assertNotNull(newValue);
                scope.setAttachment(key, newValue);
                return newValue;
            }
            return (R)existing;
        }
    }
}

