/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.remoting.transport.Transport;
import org.jboss.as.clustering.infinispan.ChannelFactoryTransport;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class JGroupsTransportServiceConfigurator
extends GlobalComponentServiceConfigurator<TransportConfiguration> {
    private volatile SupplierDependency<ChannelFactory> factory;
    private volatile SupplierDependency<String> cluster;
    private volatile String channel;
    private volatile long lockTimeout;

    public JGroupsTransportServiceConfigurator(PathAddress address) {
        super(CacheContainerComponent.TRANSPORT, address);
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(new CompositeDependency(new Dependency[]{this.factory, this.cluster}).register(builder));
    }

    public JGroupsTransportServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.lockTimeout = JGroupsTransportResourceDefinition.Attribute.LOCK_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.channel = JGroupsTransportResourceDefinition.Attribute.CHANNEL.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.factory = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, this.channel));
        this.cluster = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_CLUSTER.getServiceName(context, this.channel));
        return this;
    }

    @Override
    public TransportConfiguration get() {
        ChannelFactory factory = (ChannelFactory)this.factory.get();
        ProtocolStackConfiguration stack = factory.getProtocolStackConfiguration();
        TransportConfiguration.Topology topology = stack.getTransport().getTopology();
        TransportConfigurationBuilder builder = new GlobalConfigurationBuilder().transport().clusterName((String)this.cluster.get()).distributedSyncTimeout(this.lockTimeout).transport((Transport)new ChannelFactoryTransport(factory));
        if (topology != null) {
            builder.siteId(topology.getSite()).rackId(topology.getRack()).machineId(topology.getMachine());
        }
        return builder.create();
    }

    String getChannel() {
        return this.channel;
    }
}

