/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.Functions;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreConfiguration;
import org.reactivestreams.Publisher;
import org.wildfly.clustering.infinispan.spi.RemoteCacheContainer;

@Store(shared=true)
public class HotRodStore<K, V>
implements SegmentedAdvancedLoadWriteStore<K, V>,
Function<CloseableIterator<byte[]>, Publisher<K>>,
Consumer<K> {
    private InitializationContext ctx;
    private RemoteCache<byte[], byte[]> remoteCache;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        HotRodStoreConfiguration configuration = (HotRodStoreConfiguration)ctx.getConfiguration();
        RemoteCacheContainer remoteCacheContainer = (RemoteCacheContainer)configuration.attributes().attribute(HotRodStoreConfiguration.REMOTE_CACHE_CONTAINER).get();
        String cacheConfiguration = (String)configuration.attributes().attribute(HotRodStoreConfiguration.CACHE_CONFIGURATION).get();
        String cacheName = ctx.getCache().getName();
        try {
            ProtocolVersion protocolVersion = remoteCacheContainer.getConfiguration().version();
            if (protocolVersion.compareTo((Enum)ProtocolVersion.PROTOCOL_VERSION_27) < 0) {
                this.remoteCache = remoteCacheContainer.getCache(cacheName, false);
                if (this.remoteCache == null) {
                    throw InfinispanLogger.ROOT_LOGGER.remoteCacheMustBeDefined(protocolVersion.toString(), cacheName);
                }
            } else {
                InfinispanLogger.ROOT_LOGGER.remoteCacheCreated(cacheName, cacheConfiguration);
                this.remoteCache = remoteCacheContainer.administration().getOrCreateCache(cacheName, cacheConfiguration);
            }
        }
        catch (HotRodClientException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public MarshalledEntry<K, V> load(Object key) throws PersistenceException {
        byte[] bytes = (byte[])this.remoteCache.get((Object)this.marshall(key));
        if (bytes == null) {
            return null;
        }
        Map.Entry<ByteBuffer, ByteBuffer> entry = this.unmarshallValue(bytes);
        return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, entry.getKey(), entry.getValue());
    }

    private MarshalledEntry<K, V> asMarshalledEntry(Object key) {
        return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, null, (InternalMetadata)null);
    }

    public void write(MarshalledEntry<? extends K, ? extends V> entry) {
        this.remoteCache.put((Object)this.marshall(entry.getKey()), (Object)this.marshall(entry));
    }

    public void writeBatch(Iterable<MarshalledEntry<? extends K, ? extends V>> marshalledEntries) {
        HashMap<byte[], byte[]> batch = new HashMap<byte[], byte[]>();
        for (MarshalledEntry<K, V> marshalledEntry : marshalledEntries) {
            batch.put(this.marshall(marshalledEntry.getKey()), this.marshall(marshalledEntry));
        }
        if (!batch.isEmpty()) {
            this.remoteCache.putAll(batch);
        }
    }

    public boolean contains(Object key) {
        return this.remoteCache.containsKey((Object)this.marshall(key));
    }

    public boolean delete(Object key) {
        return this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)this.marshall(key)) != null;
    }

    public Flowable<K> publishKeys(Predicate<? super K> filter) {
        return this.publishKeys(null, filter);
    }

    public Flowable<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        Flowable keys = Flowable.using((Callable)Functions.justCallable((Object)this.remoteCache.keySet(segments).iterator()), (Function)this, CloseableIterator::close);
        return filter != null ? keys.filter(filter::test) : keys;
    }

    public Publisher<K> apply(CloseableIterator<byte[]> iterator) {
        return Flowable.fromIterable(new SimpleIterable(new IteratorMapper(iterator, this::unmarshallKey)));
    }

    public Publisher<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.publishEntries(null, filter, fetchValue, fetchMetadata);
    }

    public Publisher<MarshalledEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        Flowable<? super K> keys = this.publishKeys(filter);
        return fetchValue || fetchMetadata ? keys.map(this::load) : keys.map(this::asMarshalledEntry);
    }

    public int size() {
        return this.remoteCache.size();
    }

    public void clear() {
        this.remoteCache.clear();
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener<? super K> listener) {
    }

    private byte[] marshall(Object key) {
        try {
            return key instanceof WrappedByteArray ? ((WrappedByteArray)key).getBytes() : this.ctx.getMarshaller().objectToByteBuffer(key);
        }
        catch (IOException | InterruptedException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private byte[] marshall(MarshalledEntry<? extends K, ? extends V> entry) {
        return this.marshall(new AbstractMap.SimpleImmutableEntry<ByteBuffer, ByteBuffer>(entry.getValueBytes(), entry.getMetadataBytes()));
    }

    private K unmarshallKey(byte[] bytes) {
        return (K)this.unmarshall(bytes);
    }

    private Map.Entry<ByteBuffer, ByteBuffer> unmarshallValue(byte[] bytes) {
        return (Map.Entry)this.unmarshall(bytes);
    }

    private Object unmarshall(byte[] bytes) {
        try {
            return this.ctx.getMarshaller().objectFromByteBuffer(bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public boolean isAvailable() {
        PingOperation.PingResponse response = ((RemoteCacheImpl)this.remoteCache).ping();
        return response.isSuccess();
    }

    public int size(IntSet segments) {
        return PersistenceUtil.count((SegmentedAdvancedLoadWriteStore)this, (IntSet)segments);
    }

    public void clear(IntSet segments) {
        this.publishKeys(segments, null).blockingForEach((Consumer)this);
    }

    public void accept(K key) {
        this.remoteCache.remove((Object)this.marshall(key));
    }

    private static class SimpleIterable<T>
    implements Iterable<T> {
        private final Iterator<T> iterator;

        SimpleIterable(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }
}

