/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.serialization.factories;

import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.annotation.JsonInclude;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonFactory;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.MapperFeature;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.ObjectMapper;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.ObjectReader;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.ObjectWriter;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.SerializationConfig;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.SerializationFeature;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.module.SimpleModule;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.factories.PojoSerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

public class JacksonFactory
implements PojoSerializerFactory {
    private static final ObjectMapper globalMapper = JacksonFactory.createObjectMapper();
    private static final JacksonFactory instance = new JacksonFactory(globalMapper);
    private final ObjectMapper mapper;

    public static JacksonFactory getInstance() {
        return instance;
    }

    private JacksonFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper(JacksonFactory.createJsonFactory());
        SerializationConfig scfg = mapper.getSerializationConfig();
        scfg = scfg.withFeatures(SerializationFeature.FAIL_ON_SELF_REFERENCES, SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS, SerializationFeature.WRAP_EXCEPTIONS);
        scfg = scfg.withoutFeatures(SerializationFeature.CLOSE_CLOSEABLE, SerializationFeature.EAGER_SERIALIZER_FETCH, SerializationFeature.FAIL_ON_EMPTY_BEANS, SerializationFeature.FLUSH_AFTER_WRITE_VALUE, SerializationFeature.INDENT_OUTPUT, SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID, SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS, SerializationFeature.WRAP_ROOT_VALUE);
        mapper.setConfig(scfg);
        DeserializationConfig dcfg = mapper.getDeserializationConfig();
        dcfg = dcfg.withFeatures(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, DeserializationFeature.WRAP_EXCEPTIONS);
        dcfg = dcfg.withoutFeatures(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setConfig(dcfg);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.enable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        mapper.enable(MapperFeature.AUTO_DETECT_FIELDS);
        mapper.enable(MapperFeature.AUTO_DETECT_GETTERS);
        mapper.enable(MapperFeature.AUTO_DETECT_IS_GETTERS);
        mapper.enable(MapperFeature.AUTO_DETECT_SETTERS);
        mapper.enable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        mapper.enable(MapperFeature.USE_STD_BEAN_NAMING);
        mapper.enable(MapperFeature.USE_ANNOTATIONS);
        mapper.disable(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        mapper.disable(MapperFeature.AUTO_DETECT_CREATORS);
        mapper.disable(MapperFeature.INFER_PROPERTY_MUTATORS);
        mapper.disable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
        mapper.disable(MapperFeature.USE_GETTERS_AS_SETTERS);
        mapper.disable(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME);
        mapper.disable(MapperFeature.USE_STATIC_TYPING);
        mapper.disable(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Void.class, new VoidDeserializer());
        mapper.registerModule(module);
        return mapper;
    }

    private static JsonFactory createJsonFactory() {
        JsonFactory factory2 = new JsonFactory();
        factory2.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
        factory2.enable(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS);
        factory2.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        factory2.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        factory2.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        factory2.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        factory2.disable(JsonParser.Feature.ALLOW_COMMENTS);
        factory2.disable(JsonParser.Feature.ALLOW_YAML_COMMENTS);
        factory2.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        factory2.disable(JsonParser.Feature.STRICT_DUPLICATE_DETECTION);
        factory2.enable(JsonGenerator.Feature.IGNORE_UNKNOWN);
        factory2.enable(JsonGenerator.Feature.QUOTE_FIELD_NAMES);
        factory2.enable(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS);
        factory2.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        factory2.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        factory2.disable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
        factory2.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        factory2.disable(JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION);
        factory2.disable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        factory2.disable(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS);
        return factory2;
    }

    @Override
    public <T> PojoSerializer<T> getSerializer(Class<T> clazz) {
        return new ClassSerializer<T>(this.mapper, clazz);
    }

    @Override
    public PojoSerializer<Object> getSerializer(Type type) {
        return new TypeSerializer(this.mapper, type);
    }

    public JacksonFactory withNamingStrategy(PropertyNamingStrategy strategy) {
        return new JacksonFactory(this.mapper.copy().setPropertyNamingStrategy(strategy));
    }

    public JacksonFactory withMixin(Class<?> clazz, Class<?> mixin) {
        return new JacksonFactory(this.mapper.copy().addMixIn(clazz, mixin));
    }

    private static final class ClassSerializer<T>
    extends InternalSerializer<T> {
        public ClassSerializer(ObjectMapper mapper, Class<T> clazz) {
            super(mapper.reader(clazz), mapper.writerFor(clazz));
        }
    }

    private static final class TypeSerializer
    extends InternalSerializer<Object> {
        public TypeSerializer(ObjectMapper mapper, JavaType type) {
            super(mapper.reader(type), mapper.writerFor(type));
        }

        public TypeSerializer(ObjectMapper mapper, Type type) {
            this(mapper, mapper.constructType(type));
        }
    }

    private static class InternalSerializer<T>
    implements PojoSerializer<T> {
        private final ObjectReader reader;
        private final ObjectWriter writer;

        public InternalSerializer(ObjectReader reader, ObjectWriter writer) {
            this.reader = reader;
            this.writer = writer;
        }

        @Override
        public T fromJson(InputStream input) {
            try {
                return this.reader.readValue(input);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public T fromJson(String input) {
            try {
                return this.reader.readValue(input);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void toJson(T value, OutputStream output) {
            try {
                this.writer.writeValue(output, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static final class VoidDeserializer
    extends JsonDeserializer<Void> {
        private static final Void VOID = VoidDeserializer.createVoid();

        private static Void createVoid() {
            try {
                Constructor constructor = Void.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (Void)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Void deserialize(JsonParser parser, DeserializationContext ctx) {
            return VOID;
        }
    }
}

