/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.aws.lambda.core.utils;

import com.amazonaws.services.lambda.runtime.Context;
import io.thundra.merloc.common.utils.EnvironmentVariableUtils;
import io.thundra.merloc.common.utils.StringUtils;
import java.util.Map;

public final class LambdaUtils {
    private LambdaUtils() {
    }

    public static String getRegion() {
        return LambdaUtils.getEnvVar("AWS_REGION");
    }

    public static Integer getMemorySize() {
        String memorySizeValue = LambdaUtils.getEnvVar("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
        if (StringUtils.isNullOrEmpty(memorySizeValue)) {
            return -1;
        }
        return Integer.parseInt(memorySizeValue);
    }

    public static String getFunctionName() {
        return LambdaUtils.getEnvVar("AWS_LAMBDA_FUNCTION_NAME");
    }

    public static String getFunctionVersion(Context context) {
        try {
            return context.getFunctionVersion();
        }
        catch (NoSuchMethodError error) {
            return LambdaUtils.getFunctionVersion();
        }
    }

    public static String getFunctionVersion() {
        String logStreamName;
        String functionVersion = LambdaUtils.getEnvVar("AWS_LAMBDA_FUNCTION_VERSION");
        if (functionVersion == null && (logStreamName = LambdaUtils.getLogStreamName()) != null) {
            int versionStart = logStreamName.indexOf("[");
            int versionEnd = logStreamName.indexOf("]", versionStart);
            if (versionStart > 0 && versionEnd > 0) {
                functionVersion = logStreamName.substring(versionStart + 1, versionEnd);
            }
        }
        return functionVersion;
    }

    public static String getInvokedFunctionArn(Context context) {
        try {
            return context.getInvokedFunctionArn();
        }
        catch (NoSuchMethodError error) {
            return null;
        }
    }

    public static String getLogGroupName() {
        return LambdaUtils.getEnvVar("AWS_LAMBDA_LOG_GROUP_NAME");
    }

    public static String getLogStreamName() {
        return LambdaUtils.getEnvVar("AWS_LAMBDA_LOG_STREAM_NAME");
    }

    public static String getInstanceId() {
        String logStreamName = LambdaUtils.getLogStreamName();
        if (!StringUtils.hasValue(logStreamName)) {
            return null;
        }
        int logStreamNameStart = logStreamName.lastIndexOf("]");
        if (logStreamNameStart > 0) {
            return logStreamName.substring(logStreamNameStart + 1);
        }
        return logStreamName;
    }

    public static String getAccountId(Context context) {
        String[] arnParts;
        if (context != null && StringUtils.hasValue(LambdaUtils.getInvokedFunctionArn(context)) && (arnParts = LambdaUtils.getInvokedFunctionArn(context).split(":")).length >= 5) {
            return arnParts[4];
        }
        return null;
    }

    public static String getAlias(Context context) {
        String[] arnParts;
        if (context != null && StringUtils.hasValue(LambdaUtils.getInvokedFunctionArn(context)) && (arnParts = LambdaUtils.getInvokedFunctionArn(context).split(":")).length == 8) {
            return arnParts[7];
        }
        return null;
    }

    public static String getEnvVar(String name) {
        return EnvironmentVariableUtils.get(name);
    }

    public static Map<String, String> getEnvVars() {
        return EnvironmentVariableUtils.getAll();
    }

    public static String getEnvVarCaseInsensitive(String name, String defaultValue) {
        for (Map.Entry<String, String> e : EnvironmentVariableUtils.getAll().entrySet()) {
            if (!e.getKey().equalsIgnoreCase(name)) continue;
            return e.getValue();
        }
        return defaultValue;
    }

    public static String getEnvVarCaseInsensitive(String name) {
        return LambdaUtils.getEnvVarCaseInsensitive(name, null);
    }

    public static String getInstanceId(Context context) {
        String logStreamName = context.getLogStreamName();
        if (!StringUtils.hasValue(logStreamName)) {
            return null;
        }
        int logStreamNameStart = logStreamName.lastIndexOf("]");
        if (logStreamNameStart > 0) {
            return logStreamName.substring(logStreamNameStart + 1);
        }
        return logStreamName;
    }
}

