/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.aws.lambda.runtime.embedded;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ManagedEnvironmentVariables
extends HashMap<String, String> {
    private final Map<String, String> realEnvVars;
    private final Map<ThreadGroup, Map<String, String>> threadGroupEnvVars;

    public ManagedEnvironmentVariables(Map<String, String> realEnvVars) {
        this.realEnvVars = realEnvVars;
        this.threadGroupEnvVars = new ConcurrentHashMap<ThreadGroup, Map<String, String>>();
    }

    public ManagedEnvironmentVariables(Map<String, String> realEnvVars, ManagedEnvironmentVariables masterManagedEnvVars) {
        this.realEnvVars = realEnvVars;
        this.threadGroupEnvVars = masterManagedEnvVars.threadGroupEnvVars;
    }

    private Map<String, String> getDelegate() {
        for (ThreadGroup tg = Thread.currentThread().getThreadGroup(); tg != null; tg = tg.getParent()) {
            Map<String, String> delegate = this.threadGroupEnvVars.get(tg);
            if (delegate == null) continue;
            return delegate;
        }
        return this.realEnvVars;
    }

    public Map<String, String> getThreadGroupAwareEnvVars() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (tg != null) {
            return this.threadGroupEnvVars.get(tg);
        }
        return null;
    }

    public void setThreadGroupAwareEnvVars(Map<String, String> envVars) {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (tg != null) {
            this.threadGroupEnvVars.put(tg, envVars);
        }
    }

    public void clearThreadGroupAwareEnvVars() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (tg != null) {
            this.threadGroupEnvVars.remove(tg);
        }
    }

    @Override
    public String put(String key, String value) {
        return this.getDelegate().put(key, value);
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public String get(Object key) {
        return this.getDelegate().get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.getDelegate().putAll(m);
    }

    @Override
    public String remove(Object key) {
        return this.getDelegate().remove(key);
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.getDelegate().keySet();
    }

    @Override
    public Collection<String> values() {
        return this.getDelegate().values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getDelegate().entrySet();
    }

    @Override
    public String getOrDefault(Object key, String defaultValue) {
        return this.getDelegate().getOrDefault(key, defaultValue);
    }

    @Override
    public String putIfAbsent(String key, String value) {
        return this.getDelegate().putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.getDelegate().remove(key, value);
    }

    @Override
    public boolean replace(String key, String oldValue, String newValue) {
        return this.getDelegate().replace(key, oldValue, newValue);
    }

    @Override
    public String replace(String key, String value) {
        return this.getDelegate().replace(key, value);
    }

    @Override
    public String computeIfAbsent(String key, Function<? super String, ? extends String> mappingFunction) {
        return this.getDelegate().computeIfAbsent(key, mappingFunction);
    }

    @Override
    public String computeIfPresent(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return this.getDelegate().computeIfPresent(key, remappingFunction);
    }

    @Override
    public String compute(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return this.getDelegate().compute(key, remappingFunction);
    }

    @Override
    public String merge(String key, String value, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return this.getDelegate().merge(key, value, remappingFunction);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.getDelegate().forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super String, ? extends String> function) {
        this.getDelegate().replaceAll(function);
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public String toString() {
        return this.getDelegate().toString();
    }
}

