/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.aws.lambda.runtime.embedded.function;

import io.thundra.merloc.aws.lambda.runtime.embedded.ManagedEnvironmentVariables;
import io.thundra.merloc.aws.lambda.runtime.embedded.ManagedSystemProperties;
import io.thundra.merloc.aws.lambda.runtime.embedded.domain.FunctionEnvironmentInfo;
import io.thundra.merloc.aws.lambda.runtime.embedded.function.FunctionEnvironment;
import io.thundra.merloc.aws.lambda.runtime.embedded.function.FunctionEnvironmentClassLoader;
import io.thundra.merloc.aws.lambda.runtime.embedded.function.FunctionEnvironmentInitializer;
import io.thundra.merloc.aws.lambda.runtime.embedded.function.FunctionEnvironmentOutputStream;
import io.thundra.merloc.aws.lambda.runtime.embedded.io.ManagedOutputStream;
import io.thundra.merloc.common.logger.StdLogger;
import io.thundra.merloc.common.utils.ClassUtils;
import io.thundra.merloc.common.utils.ExceptionUtils;
import io.thundra.merloc.common.utils.ExecutorUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class FunctionEnvironmentManager {
    private static final String LAMBDA_WRAPPER_HANDLER_CLASS_NAME = "io.thundra.merloc.aws.lambda.core.handler.WrapperLambdaHandler";
    private static final String LAMBDA_CONTEXT_FACTORY_CLASS_NAME = "io.thundra.merloc.aws.lambda.core.handler.LambdaContextFactory";
    private static final String LAMBDA_CONTEXT_CLASS_NAME = "com.amazonaws.services.lambda.runtime.Context";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS");
    private static final long RELOAD_DELAY_TIME = 1000L;
    static final List<String> ENV_VARS_TO_REMOVE = Arrays.asList("LD_LIBRARY_PATH", "PATH", "SHLVL", "AWS_XRAY_DAEMON_ADDRESS", "AWS_XRAY_CONTEXT_MISSING", "_AWS_XRAY_DAEMON_PORT", "_AWS_XRAY_DAEMON_ADDRESS", "AWS_LAMBDA_RUNTIME_API", "LAMBDA_RUNTIME_DIR", "TZ", "LANG");
    static final List<String> ENV_VARS_TO_UPDATE = Arrays.asList("AWS_ACCESS_KEY", "AWS_ACCESS_KEY_ID", "AWS_SECRET_KEY", "AWS_SESSION_TOKEN", "_X_AMZN_TRACE_ID");
    private final ThreadGroup mainThreadGroup;
    private final ManagedEnvironmentVariables managedEnvVars;
    private final ManagedSystemProperties managedSysProps;
    private final ManagedOutputStream managedStdOutStream;
    private final ManagedOutputStream managedStdErrStream;
    private final List<byte[]> serializedInitializers;
    private final ClassLoader sysClassLoader;
    private final Collection<URL> urls;
    private final Map<String, FunctionEnvironment> functionEnvMap = new ConcurrentHashMap<String, FunctionEnvironment>();
    private final Map<String, Lock> functionEnvLockMap = new ConcurrentHashMap<String, Lock>();
    private final ScheduledExecutorService reloaderExecutorService = ExecutorUtils.newScheduledExecutorService(4, "lambda-runtime-reloader");
    private final Map<String, Reloader> functionReloaderMap = new ConcurrentHashMap<String, Reloader>();

    public FunctionEnvironmentManager(ThreadGroup mainThreadGroup, ManagedEnvironmentVariables managedEnvVars, ManagedSystemProperties managedSysProps, ManagedOutputStream managedStdOutStream, ManagedOutputStream managedStdErrStream, List<byte[]> serializedInitializers, ClassLoader sysClassLoader, Collection<URL> urls2) {
        this.mainThreadGroup = mainThreadGroup;
        this.managedEnvVars = managedEnvVars;
        this.managedSysProps = managedSysProps;
        this.managedStdOutStream = managedStdOutStream;
        this.managedStdErrStream = managedStdErrStream;
        this.serializedInitializers = serializedInitializers;
        this.sysClassLoader = sysClassLoader;
        this.urls = urls2;
    }

    private FunctionEnvironmentClassLoader createFunctionEnvironmentClassLoader() {
        FunctionEnvironmentClassLoader classLoader = new FunctionEnvironmentClassLoader(this.urls.toArray(new URL[0]), this.sysClassLoader.getParent());
        StdLogger.debug(String.format("Created classloader (%s) for the function environment with the URLs: %s", classLoader, this.urls));
        return classLoader;
    }

    private FunctionEnvironment doCreateFunctionEnvironment(ManagedOutputStream managedStdOutStream, ManagedOutputStream managedStdErrStream, ManagedEnvironmentVariables managedEnvVars, ManagedSystemProperties managedSysProps, FunctionEnvironmentClassLoader classLoader, ExecutorService executorService, String functionArn, String functionName, String functionVersion, int functionMemorySize, String originalHandlerName, long lastModified, Map<String, String> envVars, Properties sysProps, AtomicReference<String> currentRequestId) throws Exception {
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> handlerClass = classLoader.loadClass(LAMBDA_WRAPPER_HANDLER_CLASS_NAME);
        Object handler = handlerClass.newInstance();
        Class<?> contextClass = classLoader.loadClass(LAMBDA_CONTEXT_CLASS_NAME);
        Method handleRequestMethod = handlerClass.getMethod("handleRequest", InputStream.class, OutputStream.class, contextClass);
        Class<?> contextFactoryClass = classLoader.loadClass(LAMBDA_CONTEXT_FACTORY_CLASS_NAME);
        Method contextFactoryMethod = contextFactoryClass.getMethod("create", String.class, String.class, Integer.TYPE, String.class, String.class);
        return new FunctionEnvironment(managedStdOutStream, managedStdErrStream, managedEnvVars, managedSysProps, functionArn, functionName, functionVersion, functionMemorySize, originalHandlerName, lastModified, classLoader, handler, handleRequestMethod, contextFactoryMethod, executorService, envVars, sysProps, currentRequestId);
    }

    private FunctionEnvironmentInfoProxy createFunctionEnvironmentInfo(ClassLoader classLoader, String functionArn, String functionName, Map<String, String> envVars, Properties sysProps) throws Exception {
        Class<?> funcEnvInitializerClass = classLoader.loadClass(FunctionEnvironmentInitializer.class.getName());
        Class<?> funcEnvInfoClass = classLoader.loadClass(FunctionEnvironmentInfo.class.getName());
        Constructor<?> funcEnvInfoCtor = funcEnvInfoClass.getConstructor(String.class, String.class, Map.class, Properties.class);
        Object funcEnvInfo = funcEnvInfoCtor.newInstance(functionArn, functionName, envVars, sysProps);
        return new FunctionEnvironmentInfoProxy(functionArn, functionName, envVars, sysProps, funcEnvInitializerClass, funcEnvInfoClass, funcEnvInfo);
    }

    public Object deserializeFunctionEnvironmentInitializer(final ClassLoader classLoader, byte[] data) throws IOException, ClassNotFoundException {
        try (ObjectInputStream inputStream2 = new ObjectInputStream(new ByteArrayInputStream(data)){

            public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(desc.getName(), true, classLoader);
                }
                catch (Exception exception) {
                    return super.resolveClass(desc);
                }
            }
        };){
            Object object = inputStream2.readObject();
            return object;
        }
    }

    private List<Object> createInitializers(ClassLoader classLoader, String functionName) throws Exception {
        ArrayList<Object> initializers = new ArrayList<Object>(this.serializedInitializers.size());
        for (byte[] data : this.serializedInitializers) {
            Object initializer = this.deserializeFunctionEnvironmentInitializer(classLoader, data);
            StdLogger.debug(String.format("Created function environment initializer for function %s: %s", functionName, initializer));
            initializers.add(initializer);
        }
        return initializers;
    }

    private String extractHandlerRootPath(FunctionEnvironmentClassLoader classLoader, String originalHandlerName) {
        String originalHandlerClassFileName = ClassUtils.toClassFilePath(originalHandlerName);
        URL originalHandlerRootPathURL = classLoader.getResource(originalHandlerClassFileName);
        if (originalHandlerRootPathURL != null) {
            File originalHandlerRootFile;
            int idx2;
            String originalHandlerRootPath = originalHandlerRootPathURL.getPath();
            int idx1 = originalHandlerRootPath.indexOf(":/");
            if (idx1 >= 0) {
                originalHandlerRootPath = originalHandlerRootPath.substring(idx1 + 1);
            }
            if ((idx2 = originalHandlerRootPath.indexOf("!")) >= 0) {
                originalHandlerRootPath = originalHandlerRootPath.substring(0, idx2);
            }
            if (originalHandlerRootPath.endsWith(originalHandlerClassFileName)) {
                originalHandlerRootPath = originalHandlerRootPath.substring(0, originalHandlerRootPath.length() - originalHandlerClassFileName.length());
            }
            if (!(originalHandlerRootFile = new File(originalHandlerRootPath)).exists()) {
                return null;
            }
            if (originalHandlerRootFile.isFile()) {
                originalHandlerRootPath = originalHandlerRootFile.getParent();
            }
            if (originalHandlerRootPath.endsWith(File.separator)) {
                originalHandlerRootPath = originalHandlerRootPath.substring(0, originalHandlerRootPath.length() - 1);
            }
            return originalHandlerRootPath;
        }
        return null;
    }

    private void normalizeEnvVars(Map<String, String> envVars, FunctionEnvironmentClassLoader classLoader, String originalHandlerName) {
        ENV_VARS_TO_REMOVE.forEach(e -> {
            String cfr_ignored_0 = (String)envVars.remove(e);
        });
        String originalHandlerRootPath = this.extractHandlerRootPath(classLoader, originalHandlerName);
        if (originalHandlerRootPath != null) {
            envVars.put("LAMBDA_TASK_ROOT", originalHandlerRootPath);
            envVars.put("PWD", originalHandlerRootPath);
        }
    }

    private FunctionEnvironment createFunctionEnvironment(Map<String, String> functionEnvVars, String functionArn, String functionName, String functionVersion, int functionMemorySize, String originalHandlerName, long lastModified) throws Exception {
        String threadGroupName = "lambda-runtime-tg-for-" + functionName;
        String executorThreadNamePrefix = "lambda-runtime-executor-for-" + functionName;
        ThreadGroup threadGroup = new ThreadGroup(this.mainThreadGroup, threadGroupName);
        ExecutorService executorService = ExecutorUtils.newFixedExecutorService(threadGroup, 1, executorThreadNamePrefix);
        StdLogger.debug(String.format("Creating function environment for function %s (thread group name=%s, executor thread name prefix=%s)...", functionName, threadGroupName, executorThreadNamePrefix));
        try {
            Future<FunctionEnvironment> future = executorService.submit(() -> {
                FunctionEnvironmentClassLoader classLoader = this.createFunctionEnvironmentClassLoader();
                AtomicReference<String> currentRequestId = new AtomicReference<String>();
                this.normalizeEnvVars(functionEnvVars, classLoader, originalHandlerName);
                Properties sysProps = new Properties();
                FunctionEnvironmentInfoProxy funcEnvInfoProxy = this.createFunctionEnvironmentInfo(classLoader, functionArn, functionName, functionEnvVars, sysProps);
                List<Object> initializers = this.createInitializers(classLoader, functionName);
                HashMap<Object, Object> initializerContextMap = new HashMap<Object, Object>(initializers.size());
                for (Object initializer : initializers) {
                    Object context = funcEnvInfoProxy.beforeInit(initializer);
                    if (context == null) continue;
                    initializerContextMap.put(initializer, context);
                }
                this.managedEnvVars.setThreadGroupAwareEnvVars(funcEnvInfoProxy.getEnvironmentVariables());
                StdLogger.debug(String.format("Set thread group aware environment variables before creating environment for function %s: %s", functionName, functionEnvVars));
                this.managedSysProps.setThreadGroupAwareSysProps(funcEnvInfoProxy.getSystemProperties());
                StdLogger.debug(String.format("Set thread group aware system properties for function %s: %s", functionName, this.managedSysProps.getThreadGroupAwareSysProps()));
                Supplier<String> newLineHeaderSupplier = () -> {
                    LocalDateTime now = LocalDateTime.now();
                    return String.format("[MERLOC] %-20s | %36s %25s - ", functionName, currentRequestId.get() != null ? currentRequestId.get() : "", now.format(DATE_TIME_FORMATTER));
                };
                FunctionEnvironmentOutputStream functionStdOutStream = new FunctionEnvironmentOutputStream(this.managedStdOutStream.getOriginal(), newLineHeaderSupplier);
                this.managedStdOutStream.setThreadGroupAwareOutputStream(functionStdOutStream);
                FunctionEnvironmentOutputStream functionStdErrStream = new FunctionEnvironmentOutputStream(this.managedStdErrStream.getOriginal(), newLineHeaderSupplier);
                this.managedStdErrStream.setThreadGroupAwareOutputStream(functionStdErrStream);
                try {
                    FunctionEnvironment functionEnvironment = this.doCreateFunctionEnvironment(this.managedStdOutStream, this.managedStdErrStream, this.managedEnvVars, this.managedSysProps, classLoader, executorService, functionArn, functionName, functionVersion, functionMemorySize, originalHandlerName, lastModified, functionEnvVars, sysProps, currentRequestId);
                    for (Object initializer : initializers) {
                        Object context = initializerContextMap.get(initializer);
                        funcEnvInfoProxy.afterInit(initializer, context);
                    }
                    FunctionEnvironment functionEnvironment2 = functionEnvironment;
                    return functionEnvironment2;
                }
                catch (Throwable t) {
                    ExceptionUtils.sneakyThrow(t);
                    FunctionEnvironment functionEnvironment = null;
                    return functionEnvironment;
                }
            });
            try {
                FunctionEnvironment functionEnvironment = future.get();
                StdLogger.debug(String.format("Created function environment for function %s (thread group name=%s, executor thread name prefix=%s)...", functionName, threadGroupName, executorThreadNamePrefix));
                return functionEnvironment;
            }
            catch (Throwable t) {
                if (t instanceof ExecutionException) {
                    t = t.getCause();
                }
                StdLogger.error(String.format("Failed creation of function environment in sandbox for function %s (thread group name=%s, executor thread name prefix=%s)...", functionName, threadGroupName, executorThreadNamePrefix));
                ExceptionUtils.sneakyThrow(t);
            }
        }
        catch (Throwable t) {
            StdLogger.error(String.format("Failed creation of function environment for function %s (thread group name=%s, executor thread name prefix=%s)...", functionName, threadGroupName, executorThreadNamePrefix));
            executorService.shutdownNow();
            ExceptionUtils.sneakyThrow(t);
        }
        return null;
    }

    public Lock getFunctionEnvironmentLock(String functionArn) {
        ReentrantLock newLock = new ReentrantLock();
        Lock lock = this.functionEnvLockMap.putIfAbsent(functionArn, newLock);
        if (lock == null) {
            lock = newLock;
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionEnvironment getOrCreateFunctionEnvironment(Callable<Map<String, String>> functionEnvVarsBuilder, String functionArn, String functionName, String functionVersion, int functionMemorySize, String originalHandlerName, long lastModified) throws Exception {
        FunctionEnvironment functionEnv;
        Lock lock;
        block4: {
            StdLogger.debug(String.format("Getting or create function environment for function %s ...", functionName));
            lock = this.getFunctionEnvironmentLock(functionArn);
            StdLogger.debug(String.format("Locking function environment for function %s ...", functionName));
            lock.lock();
            StdLogger.debug(String.format("Locked function environment for function %s", functionName));
            try {
                functionEnv = this.functionEnvMap.get(functionArn);
                if (functionEnv != null && lastModified > functionEnv.getLastModified()) {
                    StdLogger.debug(String.format("Detected stale function environment for function %s", functionName));
                    this.functionEnvMap.remove(functionArn);
                    functionEnv.close();
                    functionEnv = null;
                }
                if (functionEnv == null) {
                    StdLogger.debug(String.format("Creating new function environment for function %s ...", functionName));
                    functionEnv = this.createFunctionEnvironment(functionEnvVarsBuilder.call(), functionArn, functionName, functionVersion, functionMemorySize, originalHandlerName, lastModified);
                    StdLogger.debug(String.format("Created new function environment for function %s", functionName));
                    this.functionEnvMap.put(functionArn, functionEnv);
                    break block4;
                }
                StdLogger.debug(String.format("Using existing function environment for function %s", functionName));
            }
            catch (Throwable throwable) {
                StdLogger.debug(String.format("Unlocking function environment for function %s ...", functionName));
                lock.unlock();
                StdLogger.debug(String.format("Unlocked function environment for function %s", functionName));
                throw throwable;
            }
        }
        StdLogger.debug(String.format("Unlocking function environment for function %s ...", functionName));
        lock.unlock();
        StdLogger.debug(String.format("Unlocked function environment for function %s", functionName));
        StdLogger.debug(String.format("Got or create function environment for function %s", functionName));
        return functionEnv;
    }

    public Collection<FunctionEnvironment> getEffectedFunctionEnvironments(String className) {
        ArrayList<FunctionEnvironment> functionEnvironments = new ArrayList<FunctionEnvironment>();
        for (FunctionEnvironment fe : this.functionEnvMap.values()) {
            if (!fe.hasLoadedClass(className)) continue;
            functionEnvironments.add(fe);
        }
        return functionEnvironments;
    }

    public void reloadFunctionEnvironment(FunctionEnvironment functionEnv) throws Exception {
        long reloadDelayTime = System.currentTimeMillis() + 1000L;
        Reloader reloader = new Reloader(functionEnv, reloadDelayTime);
        Reloader existingReloader = this.functionReloaderMap.putIfAbsent(functionEnv.getFunctionArn(), reloader);
        if (existingReloader != null) {
            existingReloader.reloadStartTime = reloadDelayTime;
        } else {
            StdLogger.debug(String.format("Scheduling reloading function environment for function %s", functionEnv.getFunctionName()));
            this.reloaderExecutorService.schedule(reloader, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public void closeFunctionEnvironments() {
        Iterator<Map.Entry<String, FunctionEnvironment>> iter = this.functionEnvMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, FunctionEnvironment> e = iter.next();
            String functionName = e.getKey();
            FunctionEnvironment functionEnvironment = e.getValue();
            StdLogger.debug(String.format("Closing environment for function %s ...", functionName));
            try {
                functionEnvironment.close();
                StdLogger.debug(String.format("Closed environment for function %s ...", functionName));
            }
            catch (Throwable t) {
                StdLogger.error(String.format("Failed to close of environment for function %s ...", functionName), t);
            }
            iter.remove();
        }
    }

    private class Reloader
    implements Runnable {
        private final FunctionEnvironment functionEnv;
        private volatile long reloadStartTime;

        public Reloader(FunctionEnvironment functionEnv, long reloadStartTime) {
            this.functionEnv = functionEnv;
            this.reloadStartTime = reloadStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTime;
            while ((currentTime = System.currentTimeMillis()) < this.reloadStartTime) {
                try {
                    Thread.sleep(this.reloadStartTime - currentTime + 1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            String functionName = this.functionEnv.getFunctionName();
            String functionArn = this.functionEnv.getFunctionArn();
            String functionVersion = this.functionEnv.getFunctionVersion();
            int functionMemorySize = this.functionEnv.getFunctionMemorySize();
            String originalHandlerName = this.functionEnv.getOriginalHandlerName();
            long lastModified = System.currentTimeMillis();
            StdLogger.info(String.format("Reloading function environment for function %s ...", functionName));
            Lock lock = FunctionEnvironmentManager.this.getFunctionEnvironmentLock(functionArn);
            StdLogger.debug(String.format("Locking function environment for function %s ...", functionName));
            lock.lock();
            StdLogger.debug(String.format("Locked function environment for function %s", functionName));
            try {
                FunctionEnvironmentManager.this.functionEnvMap.remove(this.functionEnv.getFunctionArn(), this.functionEnv);
                this.functionEnv.close();
                StdLogger.debug(String.format("Creating new function environment for function %s ...", functionName));
                FunctionEnvironment newFunctionEnv = FunctionEnvironmentManager.this.createFunctionEnvironment(this.functionEnv.getEnvironmentVariables(), functionArn, functionName, functionVersion, functionMemorySize, originalHandlerName, lastModified);
                StdLogger.debug(String.format("Created new function environment for function %s ...", functionName));
                FunctionEnvironmentManager.this.functionEnvMap.put(this.functionEnv.getFunctionArn(), newFunctionEnv);
                StdLogger.info(String.format("Reloaded function environment for function %s", functionName));
            }
            catch (Throwable t) {
                try {
                    StdLogger.error(String.format("Unable to reload function environment for function %s", functionName), t);
                }
                catch (Throwable throwable) {
                    StdLogger.debug(String.format("Unlocking function environment for function %s ...", functionName));
                    lock.unlock();
                    StdLogger.debug(String.format("Unlocked function environment for function %s", functionName));
                    FunctionEnvironmentManager.this.functionReloaderMap.remove(functionArn);
                    throw throwable;
                }
                StdLogger.debug(String.format("Unlocking function environment for function %s ...", functionName));
                lock.unlock();
                StdLogger.debug(String.format("Unlocked function environment for function %s", functionName));
                FunctionEnvironmentManager.this.functionReloaderMap.remove(functionArn);
            }
            StdLogger.debug(String.format("Unlocking function environment for function %s ...", functionName));
            lock.unlock();
            StdLogger.debug(String.format("Unlocked function environment for function %s", functionName));
            FunctionEnvironmentManager.this.functionReloaderMap.remove(functionArn);
        }
    }

    private static class FunctionEnvironmentInfoProxy {
        private final String functionArn;
        private final String functionName;
        private final Map<String, String> envVars;
        private final Properties sysProps;
        private final Class funcEnvInitializerClass;
        private final Class funcEnvInfoClass;
        private final Object funcEnvInfo;

        private FunctionEnvironmentInfoProxy(String functionArn, String functionName, Map<String, String> envVars, Properties sysProps, Class funcEnvInitializerClass, Class funcEnvInfoClass, Object funcEnvInfo) {
            this.functionArn = functionArn;
            this.functionName = functionName;
            this.envVars = envVars;
            this.sysProps = sysProps;
            this.funcEnvInitializerClass = funcEnvInitializerClass;
            this.funcEnvInfoClass = funcEnvInfoClass;
            this.funcEnvInfo = funcEnvInfo;
        }

        private Object beforeInit(Object initializer) throws Exception {
            Method beforeInitMethod = this.funcEnvInitializerClass.getMethod("beforeInit", this.funcEnvInfoClass);
            StdLogger.debug(String.format("Calling before-init of environment initializer for function %s: %s ...", this.functionName, initializer));
            Object context = beforeInitMethod.invoke(initializer, this.funcEnvInfo);
            StdLogger.debug(String.format("Called before-init of environment initializer for function %s: %s ...", this.functionName, initializer));
            return context;
        }

        private void afterInit(Object initializer, Object context) throws Exception {
            Method afterInitMethod = this.funcEnvInitializerClass.getMethod("afterInit", this.funcEnvInfoClass, Object.class);
            StdLogger.debug(String.format("Calling after-init of environment initializer for function %s: %s ...", this.functionName, initializer));
            afterInitMethod.invoke(initializer, this.funcEnvInfo, context);
            StdLogger.debug(String.format("Called after-init of environment initializer for function %s: %s", this.functionName, initializer));
        }

        private Map<String, String> getEnvironmentVariables() {
            return this.envVars;
        }

        private Properties getSystemProperties() {
            return this.sysProps;
        }
    }
}

