/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.aws.lambda.runtime.embedded.io;

import io.thundra.merloc.aws.lambda.runtime.embedded.io.NewlineAwareOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ManagedOutputStream
extends OutputStream {
    private static final char NEW_LINE = '\n';
    private final PrintStream original;
    private final Map<ThreadGroup, DelegateContext> threadGroupOutputStreams = new ConcurrentHashMap<ThreadGroup, DelegateContext>();

    public ManagedOutputStream() {
        this.original = new PrintStream(new NoOpOutputStream());
    }

    public ManagedOutputStream(PrintStream original) {
        this.original = original;
    }

    public PrintStream getOriginal() {
        return this.original;
    }

    private DelegateContext getDelegateContext() {
        for (ThreadGroup tg = Thread.currentThread().getThreadGroup(); tg != null; tg = tg.getParent()) {
            DelegateContext context = this.threadGroupOutputStreams.get(tg);
            if (context == null) continue;
            return context;
        }
        return null;
    }

    public OutputStream getThreadGroupAwareOutputStream() {
        DelegateContext context = this.getDelegateContext();
        return context != null ? context.outputStream : null;
    }

    public void setThreadGroupAwareOutputStream(OutputStream outputStream2) {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (tg != null) {
            this.threadGroupOutputStreams.put(tg, new DelegateContext(outputStream2));
        }
    }

    public void clearThreadGroupAwareOutputStream() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (tg != null) {
            this.threadGroupOutputStreams.remove(tg);
        }
    }

    private void write(int b, DelegateContext context) throws IOException {
        if (context != null) {
            Integer latestCharValue = (Integer)context.latestChar.get();
            if ((latestCharValue == null || latestCharValue.byteValue() == 10) && context.outputStream instanceof NewlineAwareOutputStream) {
                ((NewlineAwareOutputStream)context.outputStream).onNewLine();
            }
            context.outputStream.write(b);
            context.latestChar.set(b);
        } else {
            this.original.write(b);
        }
    }

    @Override
    public void write(int b) throws IOException {
        DelegateContext context = this.getDelegateContext();
        this.write(b, context);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        DelegateContext context = this.getDelegateContext();
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i], context);
        }
    }

    @Override
    public void flush() throws IOException {
        this.original.flush();
        DelegateContext context = this.getDelegateContext();
        if (context != null) {
            context.outputStream.flush();
        }
    }

    private static class NoOpOutputStream
    extends OutputStream {
        private NoOpOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }

    private static class DelegateContext {
        private final OutputStream outputStream;
        private final ThreadLocal<Integer> latestChar = new ThreadLocal();

        private DelegateContext(OutputStream outputStream2) {
            this.outputStream = outputStream2;
        }
    }
}

