/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.aws.lambda.runtime.embedded.watcher;

import io.thundra.merloc.aws.lambda.runtime.embedded.watcher.ClassPathChangeListener;
import io.thundra.merloc.aws.lambda.runtime.embedded.watcher.FileChangeEvent;
import io.thundra.merloc.aws.lambda.runtime.embedded.watcher.FileChangeType;
import io.thundra.merloc.common.logger.StdLogger;
import io.thundra.merloc.common.utils.ExecutorUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ClassPathWatcher {
    private static final int MAX_EVENT_BUFFER_SIZE = 10000;
    private final WatchService watcher;
    private final ClassPathChangeListener classPathChangeListener;
    private final Map<WatchKey, Path> keys;
    private final BlockingQueue<FileChangeEvent> eventBuffer = new LinkedBlockingQueue<FileChangeEvent>(10000);
    private final boolean recursive;
    private volatile boolean running = false;
    private final ExecutorService watcherExecutorService = ExecutorUtils.newFixedExecutorService(1, "lambda-runtime-classpath-watcher");
    private final ExecutorService publisherExecutorService = ExecutorUtils.newFixedExecutorService(1, "lambda-runtime-classpath-notification-event-publisher");

    public ClassPathWatcher(Collection<URL> urls2, ClassPathChangeListener classPathChangeListener, boolean recursive) throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.classPathChangeListener = classPathChangeListener;
        this.keys = new HashMap<WatchKey, Path>();
        this.recursive = recursive;
        for (URL url : urls2) {
            try {
                Path path = Paths.get(url.toURI());
                if (recursive) {
                    StdLogger.debug(String.format("Scanning for registration to watch: %s ...", path));
                    this.registerAll(path);
                    continue;
                }
                this.register(path);
            }
            catch (URISyntaxException e) {
                StdLogger.error(String.format("Unable to get path from URL: %s", url), e);
            }
        }
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        Path prev = this.keys.get(key);
        if (prev == null) {
            StdLogger.debug(String.format("Registered for watching: %s", dir));
        } else if (!dir.equals(prev)) {
            StdLogger.debug(String.format("Registration updated form watching: %s -> %s", prev, dir));
        }
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ClassPathWatcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void start() {
        if (!this.running) {
            this.running = true;
            this.publisherExecutorService.submit(new Publisher());
            this.watcherExecutorService.submit(new Watcher());
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.watcherExecutorService.shutdownNow();
            this.publisherExecutorService.shutdownNow();
            this.eventBuffer.clear();
        }
    }

    private class Publisher
    implements Runnable {
        private Publisher() {
        }

        @Override
        public void run() {
            while (ClassPathWatcher.this.running) {
                try {
                    FileChangeEvent event = (FileChangeEvent)ClassPathWatcher.this.eventBuffer.poll(5L, TimeUnit.SECONDS);
                    if (event == null) continue;
                    ClassPathWatcher.this.classPathChangeListener.onChange(event);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    StdLogger.error("Error occurred while publishing classpath file change events", e);
                }
            }
        }
    }

    private class Watcher
    implements Runnable {
        private Watcher() {
        }

        @Override
        public void run() {
            while (ClassPathWatcher.this.running) {
                WatchKey key;
                try {
                    key = ClassPathWatcher.this.watcher.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                Path dir = (Path)ClassPathWatcher.this.keys.get(key);
                if (dir == null) {
                    StdLogger.debug("WatchKey not recognized!");
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent ev = ClassPathWatcher.cast(event);
                    Path name = (Path)ev.context();
                    Path child = dir.resolve(name);
                    if (ClassPathWatcher.this.recursive && kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        try {
                            if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                                ClassPathWatcher.this.registerAll(child);
                            }
                        }
                        catch (IOException e) {
                            StdLogger.error(String.format("Error occurred while registering directory to watch: %s", child));
                        }
                    }
                    StdLogger.debug(String.format("Detected file system change: change type=%s, file=%s", event.kind().name(), child));
                    FileChangeType fileChangeType = FileChangeType.of(kind);
                    if (fileChangeType == null) continue;
                    FileChangeEvent fileChangeEvent = new FileChangeEvent(child.toFile(), fileChangeType);
                    ClassPathWatcher.this.eventBuffer.offer(fileChangeEvent);
                }
                boolean valid = key.reset();
                if (valid) continue;
                ClassPathWatcher.this.keys.remove(key);
                if (!ClassPathWatcher.this.keys.isEmpty()) continue;
                break;
            }
        }
    }
}

