/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.broker.client;

import io.thundra.merloc.broker.client.Data;
import io.thundra.merloc.broker.client.Error;

public class BrokerPayload {
    private Data data;
    private Error error;

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public BrokerPayload withData(Data data) {
        this.data = data;
        return this;
    }

    public BrokerPayload withDataAttribute(String name, Object value) {
        if (this.data == null) {
            this.data = new Data();
        }
        this.data.put(name, value);
        return this;
    }

    public <T> T getDataAttribute(String name) {
        if (this.data == null) {
            return null;
        }
        return (T)this.data.get(name);
    }

    public <T> T getDataAttribute(String name, T defaultValue) {
        if (this.data == null) {
            return defaultValue;
        }
        return this.data.getOrDefault(name, defaultValue);
    }

    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public BrokerPayload withError(Error error) {
        this.error = error;
        return this;
    }

    public String toString() {
        return "BrokerPayload{data=" + this.data + ", error=" + this.error + '}';
    }
}

