/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.common.utils;

import io.thundra.merloc.common.utils.UnsafeUtils;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T getObjectField(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field == null) continue;
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }

    public static <T> T getClassField(Class clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        while (clazz != Object.class) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field != null) {
                field.setAccessible(true);
                return (T)field.get(null);
            }
            clazz = clazz.getSuperclass();
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }

    public static void setObjectField(Object obj, String fieldName, Object value) {
        Unsafe unsafe = UnsafeUtils.unsafe();
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field == null) continue;
            long fieldOffset = unsafe.objectFieldOffset(field);
            unsafe.putObject(value, fieldOffset, value);
            break;
        }
    }

    public static void setClassField(Class clazz, String fieldName, Object value) {
        Unsafe unsafe = UnsafeUtils.unsafe();
        while (clazz != Object.class) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field != null) {
                Object fieldBase = unsafe.staticFieldBase(field);
                long fieldOffset = unsafe.staticFieldOffset(field);
                unsafe.putObject(fieldBase, fieldOffset, value);
                break;
            }
            clazz = clazz.getSuperclass();
        }
    }
}

