/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.common.utils;

import io.thundra.merloc.common.utils.thread.ManagedThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadUtils {
    private ThreadUtils() {
    }

    public static String newThreadName(String threadName) {
        return "merloc-" + threadName;
    }

    public static Thread newThread(Runnable runnable2, String threadName) {
        return new ManagedThread(runnable2, ThreadUtils.newThreadName(threadName));
    }

    public static Thread newThread(ThreadGroup threadGroup, Runnable runnable2, String threadName) {
        return new ManagedThread(threadGroup, runnable2, ThreadUtils.newThreadName(threadName));
    }

    public static Thread newDaemonThread(Runnable runnable2, String threadName) {
        ManagedThread thread2 = new ManagedThread(runnable2, ThreadUtils.newThreadName(threadName));
        thread2.setDaemon(true);
        return thread2;
    }

    public static Thread newDaemonThread(ThreadGroup threadGroup, Runnable runnable2, String threadName) {
        ManagedThread thread2 = new ManagedThread(threadGroup, runnable2, ThreadUtils.newThreadName(threadName));
        thread2.setDaemon(true);
        return thread2;
    }

    public static ThreadFactory newThreadFactory(final String threadNamePrefix) {
        return new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable2) {
                return ThreadUtils.newThread(runnable2, threadNamePrefix + "-" + this.threadCount.getAndIncrement());
            }
        };
    }

    public static ThreadFactory newThreadFactory(final ThreadGroup threadGroup, final String threadNamePrefix) {
        return new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable2) {
                return ThreadUtils.newThread(threadGroup, runnable2, threadNamePrefix + "-" + this.threadCount.getAndIncrement());
            }
        };
    }

    public static ThreadFactory newDaemonThreadFactory(final String threadNamePrefix) {
        return new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable2) {
                return ThreadUtils.newDaemonThread(runnable2, threadNamePrefix + "-" + this.threadCount.getAndIncrement());
            }
        };
    }

    public static ThreadFactory newDaemonThreadFactory(final ThreadGroup threadGroup, final String threadNamePrefix) {
        return new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable2) {
                return ThreadUtils.newDaemonThread(threadGroup, runnable2, threadNamePrefix + "-" + this.threadCount.getAndIncrement());
            }
        };
    }
}

