/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.merloc.thirdparty.okio;

import io.thundra.merloc.thirdparty.kotlin.Metadata;
import io.thundra.merloc.thirdparty.kotlin.jvm.internal.Intrinsics;
import io.thundra.merloc.thirdparty.okio.FileMetadata;
import io.thundra.merloc.thirdparty.okio.JvmSystemFileSystem;
import io.thundra.merloc.thirdparty.okio.Path;
import io.thundra.merloc.thirdparty.org.jetbrains.annotations.NotNull;
import io.thundra.merloc.thirdparty.org.jetbrains.annotations.Nullable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/thundra/merloc/thirdparty/okio/NioSystemFileSystem;", "Lio/thundra/merloc/thirdparty/okio/JvmSystemFileSystem;", "()V", "atomicMove", "", "source", "Lio/thundra/merloc/thirdparty/okio/Path;", "target", "createSymlink", "metadataOrNull", "Lio/thundra/merloc/thirdparty/okio/FileMetadata;", "path", "toString", "", "zeroToNull", "", "Ljava/nio/file/attribute/FileTime;", "(Ljava/nio/file/attribute/FileTime;)Ljava/lang/Long;", "io.thundra.merloc.thirdparty.okio"})
@IgnoreJRERequirement
public final class NioSystemFileSystem
extends JvmSystemFileSystem {
    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Object object;
        Intrinsics.checkNotNullParameter(path, "path");
        java.nio.file.Path nioPath = path.toNioPath();
        try {
            object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            object = Files.readAttributes(nioPath, BasicFileAttributes.class, (LinkOption[])object);
        }
        catch (NoSuchFileException _) {
            return null;
        }
        catch (FileSystemException _) {
            return null;
        }
        Object attributes = object;
        java.nio.file.Path symlinkTarget = attributes.isSymbolicLink() ? Files.readSymbolicLink(nioPath) : (java.nio.file.Path)null;
        Comparable<java.nio.file.Path> comparable = symlinkTarget;
        Path path2 = comparable == null ? null : Path.Companion.get$default(Path.Companion, comparable, false, 1, null);
        comparable = attributes.creationTime();
        Long l = comparable == null ? null : this.zeroToNull((FileTime)comparable);
        comparable = attributes.lastModifiedTime();
        Long l2 = comparable == null ? null : this.zeroToNull((FileTime)comparable);
        comparable = attributes.lastAccessTime();
        return new FileMetadata(attributes.isRegularFile(), attributes.isDirectory(), path2, attributes.size(), l, l2, comparable == null ? null : this.zeroToNull((FileTime)comparable), null, 128, null);
    }

    private final Long zeroToNull(FileTime $this$zeroToNull) {
        Long l = $this$zeroToNull.toMillis();
        boolean bl = false;
        boolean bl2 = false;
        long it = ((Number)l).longValue();
        boolean bl3 = false;
        return it != 0L ? l : null;
    }

    @Override
    public void atomicMove(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(source2.toNioPath(), target.toNioPath(), copyOptionArray);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            throw new IOException("atomic move not supported");
        }
    }

    @Override
    public void createSymlink(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        Files.createSymbolicLink(source2.toNioPath(), target.toNioPath(), new FileAttribute[0]);
    }

    @Override
    @NotNull
    public String toString() {
        return "NioSystemFileSystem";
    }
}

