/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Map;

public final class ClientConfig {
    public static final String TIDB_DRIVER_NAME = "io.tidb.bigdata.jdbc.TiDBDriver";
    public static final String MYSQL_DRIVER_NAME = "com.mysql.jdbc.Driver";
    public static final String DATABASE_URL = "tidb.database.url";
    public static final String USERNAME = "tidb.username";
    public static final String PASSWORD = "tidb.password";
    public static final String MAX_POOL_SIZE = "tidb.maximum.pool.size";
    public static final int MAX_POOL_SIZE_DEFAULT = 10;
    public static final String MIN_IDLE_SIZE = "tidb.minimum.idle.size";
    public static final int MIN_IDLE_SIZE_DEFAULT = 10;
    public static final String TIDB_WRITE_MODE = "tidb.write_mode";
    public static final String TIDB_WRITE_MODE_DEFAULT = "append";
    public static final String TIDB_REPLICA_READ = "tidb.replica-read";
    public static final boolean TIDB_REPLICA_READ_DEFAULT = false;
    public static final String TIDB_FILTER_PUSH_DOWN = "tidb.filter-push-down";
    public static final boolean TIDB_FILTER_PUSH_DOWN_DEFAULT = false;
    public static final String SNAPSHOT_TIMESTAMP = "tidb.snapshot_timestamp";
    private String pdAddresses;
    private String databaseUrl;
    private String username;
    private String password;
    private int maximumPoolSize;
    private int minimumIdleSize;
    private String writeMode;
    private boolean isReplicaRead;
    private boolean isFilterPushDown;

    public boolean isFilterPushDown() {
        return this.isFilterPushDown;
    }

    public void setFilterPushDown(boolean filterPushDown) {
        this.isFilterPushDown = filterPushDown;
    }

    public boolean isReplicaRead() {
        return this.isReplicaRead;
    }

    public void setReplicaRead(boolean replicaRead) {
        this.isReplicaRead = replicaRead;
    }

    public ClientConfig() {
        this(null, null, null, 10, 10, TIDB_WRITE_MODE_DEFAULT, false, false);
    }

    public ClientConfig(String databaseUrl, String username, String password) {
        this(databaseUrl, username, password, 10, 10, TIDB_WRITE_MODE_DEFAULT, false, false);
    }

    public ClientConfig(String databaseUrl, String username, String password, int maximumPoolSize, int minimumIdleSize, String writeMode, boolean isReplicaRead, boolean isFilterPushDown) {
        this.databaseUrl = databaseUrl;
        this.username = username;
        this.password = password;
        this.maximumPoolSize = maximumPoolSize;
        this.minimumIdleSize = minimumIdleSize;
        this.writeMode = writeMode;
        this.isReplicaRead = isReplicaRead;
        this.isFilterPushDown = isFilterPushDown;
    }

    public ClientConfig(Map<String, String> properties) {
        this(properties.get(DATABASE_URL), properties.get(USERNAME), properties.get(PASSWORD), Integer.parseInt(properties.getOrDefault(MAX_POOL_SIZE, Integer.toString(10))), Integer.parseInt(properties.getOrDefault(MIN_IDLE_SIZE, Integer.toString(10))), properties.getOrDefault(TIDB_WRITE_MODE, TIDB_WRITE_MODE_DEFAULT), Boolean.parseBoolean(properties.getOrDefault(TIDB_REPLICA_READ, Boolean.toString(false))), Boolean.parseBoolean(properties.getOrDefault(TIDB_FILTER_PUSH_DOWN, Boolean.toString(false))));
    }

    public ClientConfig(ClientConfig config) {
        this(config.getDatabaseUrl(), config.getUsername(), config.getPassword(), config.getMaximumPoolSize(), config.getMinimumIdleSize(), config.getWriteMode(), config.isReplicaRead(), config.isFilterPushDown());
    }

    public String getPdAddresses() {
        return this.pdAddresses;
    }

    public void setPdAddresses(String addresses) {
        this.pdAddresses = addresses;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getMinimumIdleSize() {
        return this.minimumIdleSize;
    }

    public void setMinimumIdleSize(int minimumIdleSize) {
        this.minimumIdleSize = minimumIdleSize;
    }

    public String getWriteMode() {
        return this.writeMode;
    }

    public void setWriteMode(String writeMode) {
        this.writeMode = writeMode;
    }

    public String getDriverName() {
        if (this.databaseUrl.startsWith("jdbc:mysql://")) {
            return MYSQL_DRIVER_NAME;
        }
        if (this.databaseUrl.startsWith("jdbc:tidb://")) {
            return TIDB_DRIVER_NAME;
        }
        throw new IllegalArgumentException("can not parse driver by " + this.databaseUrl);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pdAddresses, this.databaseUrl, this.username, this.password, this.maximumPoolSize, this.minimumIdleSize, this.writeMode, this.isReplicaRead});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientConfig that = (ClientConfig)object;
        return this.maximumPoolSize == that.maximumPoolSize && this.minimumIdleSize == that.minimumIdleSize && this.isReplicaRead == that.isReplicaRead && Objects.equal((Object)this.pdAddresses, (Object)that.pdAddresses) && Objects.equal((Object)this.databaseUrl, (Object)that.databaseUrl) && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.password, (Object)that.password) && Objects.equal((Object)this.writeMode, (Object)that.writeMode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("databaseUrl", (Object)this.databaseUrl).add("username", (Object)this.username).add("pdAddresses", (Object)this.pdAddresses).add("maximumPoolSize", this.maximumPoolSize).add("minimumIdleSize", this.minimumIdleSize).add("writeMode", (Object)this.writeMode).add("isReplicaRead", this.isReplicaRead).toString();
    }
}

