/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.tidb.bigdata.tidb.Base64KeyRange;
import io.tidb.bigdata.tidb.ClientConfig;
import io.tidb.bigdata.tidb.ColumnHandleInternal;
import io.tidb.bigdata.tidb.SqlUtils;
import io.tidb.bigdata.tidb.TableHandleInternal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.common.TiSession;
import org.tikv.common.catalog.Catalog;
import org.tikv.common.key.RowKey;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiDAGRequest;
import org.tikv.common.meta.TiDBInfo;
import org.tikv.common.meta.TiIndexColumn;
import org.tikv.common.meta.TiIndexInfo;
import org.tikv.common.meta.TiPartitionDef;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.operation.iterator.CoprocessorIterator;
import org.tikv.common.region.RegionManager;
import org.tikv.common.row.Row;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.common.util.RangeSplitter;
import shade.com.google.protobuf.ByteString;

public final class ClientSession
implements AutoCloseable {
    static final Logger LOG = LoggerFactory.getLogger(ClientSession.class);
    private final ClientConfig config;
    private final TiSession session;
    private final Catalog catalog;
    private final HikariDataSource dataSource;

    private ClientSession(final ClientConfig config) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.dataSource = new HikariDataSource(new HikariConfig(){
            {
                this.setJdbcUrl(Objects.requireNonNull(config.getDatabaseUrl(), "database url can not be null"));
                this.setUsername(Objects.requireNonNull(config.getUsername(), "username can not be null"));
                this.setPassword(config.getPassword());
                this.setDriverClassName(config.getDriverName());
                this.setMaximumPoolSize(config.getMaximumPoolSize());
                this.setMinimumIdle(config.getMinimumIdleSize());
            }
        });
        this.loadPdAddresses();
        TiConfiguration tiConfiguration = TiConfiguration.createDefault((String)config.getPdAddresses());
        tiConfiguration.setReplicaRead(config.isReplicaRead());
        this.session = TiSession.create((TiConfiguration)tiConfiguration);
        this.catalog = this.session.getCatalog();
    }

    public List<String> getSchemaNames() {
        return (List)this.catalog.listDatabases().stream().map(TiDBInfo::getName).collect(ImmutableList.toImmutableList());
    }

    public List<String> getTableNames(String schema) {
        Objects.requireNonNull(schema, "schema is null");
        TiDBInfo db = this.catalog.getDatabase(schema);
        if (db == null) {
            return ImmutableList.of();
        }
        return (List)this.catalog.listTables(db).stream().map(TiTableInfo::getName).collect(ImmutableList.toImmutableList());
    }

    public Optional<TiTableInfo> getTable(TableHandleInternal handle) {
        return this.getTable(handle.getSchemaName(), handle.getTableName());
    }

    public Optional<TiTableInfo> getTable(String schema, String tableName) {
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        return Optional.ofNullable(this.catalog.getTable(schema, tableName));
    }

    public TiTableInfo getTableMust(TableHandleInternal handle) {
        return this.getTableMust(handle.getSchemaName(), handle.getTableName());
    }

    public TiTableInfo getTableMust(String schema, String tableName) {
        return this.getTable(schema, tableName).orElseThrow(() -> new IllegalStateException("Table " + schema + "." + tableName + " no longer exists"));
    }

    public Map<String, List<String>> listTables(Optional<String> schemaName) {
        List schemaNames = schemaName.map(s -> ImmutableList.of((Object)s)).orElseGet(() -> this.getSchemaNames());
        return (Map)schemaNames.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), name -> this.getTableNames((String)name)));
    }

    private static List<ColumnHandleInternal> getTableColumns(TiTableInfo table) {
        return (List)Streams.mapWithIndex(table.getColumns().stream(), (column, i) -> new ColumnHandleInternal(column.getName(), column.getType(), (int)i)).collect(ImmutableList.toImmutableList());
    }

    public Optional<List<ColumnHandleInternal>> getTableColumns(String schema, String tableName) {
        return this.getTable(schema, tableName).map(ClientSession::getTableColumns);
    }

    public Optional<List<ColumnHandleInternal>> getTableColumns(String schema, String tableName, List<String> columns) {
        Set columnsSet = (Set)columns.stream().collect(ImmutableSet.toImmutableSet());
        return this.getTableColumns(schema, tableName).map(r -> (ImmutableList)r.stream().filter(column -> columnsSet.contains(column.getName())).collect(ImmutableList.toImmutableList()));
    }

    public Optional<List<ColumnHandleInternal>> getTableColumns(TableHandleInternal tableHandle) {
        return this.getTableColumns(tableHandle.getSchemaName(), tableHandle.getTableName());
    }

    public Optional<List<ColumnHandleInternal>> getTableColumns(TableHandleInternal tableHandle, List<String> columns) {
        return this.getTableColumns(tableHandle.getSchemaName(), tableHandle.getTableName(), columns);
    }

    private List<RangeSplitter.RegionTask> getRangeRegionTasks(ByteString startKey, ByteString endKey) {
        ImmutableList keyRanges = ImmutableList.of((Object)KeyRangeUtils.makeCoprocRange((ByteString)startKey, (ByteString)endKey));
        return RangeSplitter.newSplitter((RegionManager)this.session.getRegionManager()).splitRangeByRegion((List)keyRanges);
    }

    private List<RangeSplitter.RegionTask> getRangeRegionTasks(Base64KeyRange range) {
        ByteString startKey = ByteString.copyFrom((byte[])Base64.getDecoder().decode(range.getStartKey()));
        ByteString endKey = ByteString.copyFrom((byte[])Base64.getDecoder().decode(range.getEndKey()));
        return this.getRangeRegionTasks(startKey, endKey);
    }

    private List<RangeSplitter.RegionTask> getTableRegionTasks(TableHandleInternal tableHandle) {
        return this.getTable(tableHandle).map(table -> table.isPartitionEnabled() ? table.getPartitionInfo().getDefs().stream().map(TiPartitionDef::getId).collect(Collectors.toList()) : ImmutableList.of((Object)table.getId())).orElseGet(ImmutableList::of).stream().flatMap(Stream::of).map(tableId -> this.getRangeRegionTasks(RowKey.createMin((long)tableId).toByteString(), RowKey.createBeyondMax((long)tableId).toByteString())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Base64KeyRange> getTableRanges(TableHandleInternal tableHandle) {
        Base64.Encoder encoder = Base64.getEncoder();
        return (List)this.getTableRegionTasks(tableHandle).stream().flatMap(task -> task.getRanges().stream().map(range -> {
            String taskStart = encoder.encodeToString(range.getStart().toByteArray());
            String taskEnd = encoder.encodeToString(range.getEnd().toByteArray());
            return new Base64KeyRange(taskStart, taskEnd);
        })).collect(ImmutableList.toImmutableList());
    }

    public TiDAGRequest.Builder request(TableHandleInternal table, List<String> columns) {
        TiTableInfo tableInfo = this.getTableMust(table);
        if (columns.isEmpty()) {
            columns = ImmutableList.of((Object)((TiColumnInfo)tableInfo.getColumns().get(0)).getName());
        }
        return TiDAGRequest.Builder.newBuilder().setFullTableScan(tableInfo).addRequiredCols(columns).setStartTs(this.session.getTimestamp());
    }

    public CoprocessorIterator<Row> iterate(TiDAGRequest.Builder request, Base64KeyRange range) {
        return CoprocessorIterator.getRowIterator((TiDAGRequest)request.build(TiDAGRequest.PushDownType.NORMAL), this.getRangeRegionTasks(range), (TiSession)this.session);
    }

    private void loadPdAddresses() {
        if (this.config.getPdAddresses() == null) {
            ArrayList<String> pdAddressesList = new ArrayList<String>();
            try (Connection connection = this.dataSource.getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT `INSTANCE` FROM `INFORMATION_SCHEMA`.`CLUSTER_INFO` WHERE `TYPE` = 'pd'");){
                while (resultSet.next()) {
                    pdAddressesList.add(resultSet.getString("INSTANCE"));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("can not get pdAddresses", e);
            }
            this.config.setPdAddresses(String.join((CharSequence)",", pdAddressesList));
        }
    }

    public void sqlUpdate(String ... sqls) {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                LOG.info("sql update: " + sql);
                statement.executeUpdate(sql);
            }
        }
        catch (Exception e) {
            LOG.error("execute sql fail", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public void createTable(String databaseName, String tableName, List<String> columnNames, List<String> columnTypes, List<String> primaryKeyColumns, List<String> uniqueKeyColumns, boolean ignoreIfExists) {
        this.sqlUpdate(SqlUtils.getCreateTableSql(Objects.requireNonNull(databaseName), Objects.requireNonNull(tableName), Objects.requireNonNull(columnNames), Objects.requireNonNull(columnTypes), primaryKeyColumns, uniqueKeyColumns, ignoreIfExists));
    }

    public void dropTable(String databaseName, String tableName, boolean ignoreIfNotExists) {
        this.sqlUpdate(String.format("DROP TABLE %s `%s`.`%s`", ignoreIfNotExists ? "IF EXISTS" : "", Objects.requireNonNull(databaseName), Objects.requireNonNull(tableName)));
    }

    public void createDatabase(String databaseName, boolean ignoreIfExists) {
        this.sqlUpdate(String.format("CREATE DATABASE %s `%s`", ignoreIfExists ? "IF NOT EXISTS" : "", Objects.requireNonNull(databaseName)));
    }

    public void dropDatabase(String databaseName, boolean ignoreIfNotExists) {
        this.sqlUpdate(String.format("DROP DATABASE %s `%s`", ignoreIfNotExists ? "IF EXISTS" : "", Objects.requireNonNull(databaseName)));
    }

    public boolean databaseExists(String databaseName) {
        return this.getSchemaNames().contains(Objects.requireNonNull(databaseName));
    }

    public boolean tableExists(String databaseName, String tableName) {
        return this.databaseExists(Objects.requireNonNull(databaseName)) && this.getTableNames(databaseName).contains(Objects.requireNonNull(tableName));
    }

    public void renameTable(String oldDatabaseName, String newDatabaseName, String oldTableName, String newTableName) {
        this.sqlUpdate(String.format("RENAME TABLE `%s`.`%s` TO `%s`.`%s` ", Objects.requireNonNull(oldDatabaseName), Objects.requireNonNull(oldTableName), Objects.requireNonNull(newDatabaseName), Objects.requireNonNull(newTableName)));
    }

    public void addColumn(String databaseName, String tableName, String columnName, String columnType) {
        this.sqlUpdate(String.format("ALTER TABLE `%s`.`%s` ADD COLUMN `%s` %s", Objects.requireNonNull(databaseName), Objects.requireNonNull(tableName), Objects.requireNonNull(columnName), Objects.requireNonNull(columnType)));
    }

    public void renameColumn(String databaseName, String tableName, String oldName, String newName, String newType) {
        this.sqlUpdate(String.format("ALTER TABLE `%s`.`%s` CHANGE `%s` `%s` %s", Objects.requireNonNull(databaseName), Objects.requireNonNull(tableName), Objects.requireNonNull(oldName), Objects.requireNonNull(newName), Objects.requireNonNull(newType)));
    }

    public void dropColumn(String databaseName, String tableName, String columnName) {
        this.sqlUpdate(String.format("ALTER TABLE `%s`.`%s` DROP COLUMN `%s`", Objects.requireNonNull(databaseName), Objects.requireNonNull(tableName), Objects.requireNonNull(columnName)));
    }

    public Connection getJdbcConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("config", (Object)this.config).toString();
    }

    public List<String> getPrimaryKeyColumns(String databaseName, String tableName) {
        return this.getTableMust(databaseName, tableName).getColumns().stream().filter(TiColumnInfo::isPrimaryKey).map(TiColumnInfo::getName).collect(Collectors.toList());
    }

    public List<String> getUniqueKeyColumns(String databaseName, String tableName) {
        List<String> primaryKeyColumns = this.getPrimaryKeyColumns(databaseName, tableName);
        return this.getTableMust(databaseName, tableName).getIndices().stream().filter(TiIndexInfo::isUnique).map(TiIndexInfo::getIndexColumns).flatMap(Collection::stream).map(TiIndexColumn::getName).filter(name -> !primaryKeyColumns.contains(name)).collect(Collectors.toList());
    }

    @Override
    public synchronized void close() throws Exception {
        this.session.close();
        this.dataSource.close();
    }

    public static ClientSession createWithSingleConnection(ClientConfig config) {
        ClientConfig clientConfig = new ClientConfig(config);
        clientConfig.setMaximumPoolSize(1);
        clientConfig.setMinimumIdleSize(1);
        return new ClientSession(clientConfig);
    }

    public static ClientSession create(ClientConfig config) {
        return new ClientSession(new ClientConfig(config));
    }
}

