/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import com.google.common.base.Preconditions;
import io.tidb.bigdata.tidb.Serialization;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.tikv.common.expression.ArithmeticBinaryExpression;
import org.tikv.common.expression.ColumnRef;
import org.tikv.common.expression.ComparisonBinaryExpression;
import org.tikv.common.expression.Constant;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.IsNull;
import org.tikv.common.expression.LogicalBinaryExpression;
import org.tikv.common.expression.Not;
import org.tikv.common.expression.StringRegExpression;
import org.tikv.common.types.DataType;
import org.tikv.common.types.IntegerType;

public final class Expressions {
    private static final Expression CONSTANT_0 = new Constant((Object)0, (DataType)IntegerType.TINYINT);
    private static final Expression CONSTANT_1 = new Constant((Object)1, (DataType)IntegerType.TINYINT);
    private static final Expression ALWAYS_FALSE = Expressions.equal(CONSTANT_0, CONSTANT_1);
    private static final Expression ALWAYS_TRUE = Expressions.equal(CONSTANT_1, CONSTANT_1);

    public static Expression alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static Expression alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static Expression constant(Object value, DataType type) {
        return new Constant(value, type);
    }

    public static Expression column(String name, DataType dataType) {
        return new ColumnRef(name, dataType);
    }

    public static Expression equal(Expression lhs, Expression rhs) {
        return ComparisonBinaryExpression.equal((Expression)lhs, (Expression)rhs);
    }

    public static Expression notEqual(Expression lhs, Expression rhs) {
        return ComparisonBinaryExpression.notEqual((Expression)lhs, (Expression)rhs);
    }

    public static Expression lessThan(Expression lhs, Expression rhs) {
        return ComparisonBinaryExpression.lessThan((Expression)lhs, (Expression)rhs);
    }

    public static Expression lessEqual(Expression lhs, Expression rhs) {
        return ComparisonBinaryExpression.lessEqual((Expression)lhs, (Expression)rhs);
    }

    public static Expression greaterThan(Expression lhs, Expression rhs) {
        return ComparisonBinaryExpression.greaterThan((Expression)lhs, (Expression)rhs);
    }

    public static Expression greaterEqual(Expression lhs, Expression rhs) {
        return ComparisonBinaryExpression.greaterEqual((Expression)lhs, (Expression)rhs);
    }

    public static Expression plus(Expression lhs, Expression rhs) {
        return ArithmeticBinaryExpression.plus((Expression)lhs, (Expression)rhs);
    }

    public static Expression minus(Expression lhs, Expression rhs) {
        return ArithmeticBinaryExpression.minus((Expression)lhs, (Expression)rhs);
    }

    public static Expression multiply(Expression lhs, Expression rhs) {
        return ArithmeticBinaryExpression.multiply((Expression)lhs, (Expression)rhs);
    }

    public static Expression divide(Expression lhs, Expression rhs) {
        return ArithmeticBinaryExpression.divide((Expression)lhs, (Expression)rhs);
    }

    public static Expression bitAnd(Expression lhs, Expression rhs) {
        return ArithmeticBinaryExpression.bitAnd((Expression)lhs, (Expression)rhs);
    }

    public static Expression bitOr(Expression lhs, Expression rhs) {
        return ArithmeticBinaryExpression.bitOr((Expression)lhs, (Expression)rhs);
    }

    public static Expression bitXor(Expression lhs, Expression rhs) {
        return ArithmeticBinaryExpression.bitXor((Expression)lhs, (Expression)rhs);
    }

    public static Expression isNull(Expression exp) {
        return new IsNull(exp);
    }

    public static Expression not(Expression exp) {
        return new Not(exp);
    }

    public static Expression and(Expression lhs, Expression rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return LogicalBinaryExpression.and((Expression)lhs, (Expression)rhs);
    }

    public static Expression and(Stream<Expression> expressions) {
        return expressions.reduce(null, Expressions::and);
    }

    public static Expression and(Collection<Expression> expressions) {
        return Expressions.and(expressions.stream());
    }

    public static Optional<Expression> and(Optional<Expression> lhs, Optional<Expression> rhs) {
        return Optional.ofNullable(Expressions.and(lhs.orElse(null), rhs.orElse(null)));
    }

    public static Expression or(Expression lhs, Expression rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return LogicalBinaryExpression.or((Expression)lhs, (Expression)rhs);
    }

    public static Expression or(Stream<Expression> expressions) {
        return expressions.reduce(null, Expressions::or);
    }

    public static Expression or(Collection<Expression> expressions) {
        return Expressions.or(expressions.stream());
    }

    public static Expression in(Collection<Expression> expressions) {
        Preconditions.checkState((expressions.size() > 1 ? 1 : 0) != 0);
        Stream<Expression> stream = expressions.stream();
        ColumnRef column = (ColumnRef)stream.findFirst().get();
        return Expressions.or(stream.skip(1L).map(expression -> Expressions.equal((Expression)column, expression)));
    }

    public static Expression xor(Expression lhs, Expression rhs) {
        return LogicalBinaryExpression.xor((Expression)lhs, (Expression)rhs);
    }

    public static Expression startsWith(Expression lhs, Expression rhs) {
        return StringRegExpression.startsWith((Expression)lhs, (Expression)rhs);
    }

    public static Expression contains(Expression lhs, Expression rhs) {
        return StringRegExpression.contains((Expression)lhs, (Expression)rhs);
    }

    public static Expression endsWith(Expression lhs, Expression rhs) {
        return StringRegExpression.endsWith((Expression)lhs, (Expression)rhs);
    }

    public static Expression like(Expression lhs, Expression rhs) {
        return StringRegExpression.like((Expression)lhs, (Expression)rhs);
    }

    public static String serialize(Expression expression) {
        return Serialization.serialize(expression);
    }

    public static Expression deserialize(String base64) {
        return (Expression)Serialization.deserialize(base64);
    }
}

