/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import com.google.common.base.MoreObjects;
import io.tidb.bigdata.tidb.ClientSession;
import io.tidb.bigdata.tidb.ColumnHandleInternal;
import io.tidb.bigdata.tidb.TableHandleInternal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MetadataInternal {
    private final String connectorId;
    private final ClientSession session;

    public MetadataInternal(String connectorId, ClientSession session) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public List<String> listSchemaNames() {
        return this.session.getSchemaNames();
    }

    public Optional<TableHandleInternal> getTableHandle(String schemaName, String tableName) {
        return this.session.getTable(schemaName, tableName).map(t -> new TableHandleInternal(this.connectorId, schemaName, tableName));
    }

    public Map<String, List<String>> listTables(Optional<String> schemaName) {
        return this.session.listTables(schemaName);
    }

    public Optional<List<ColumnHandleInternal>> getColumnHandles(TableHandleInternal tableHandle) {
        return this.session.getTableColumns(tableHandle);
    }

    public Optional<List<ColumnHandleInternal>> getColumnHandles(String schemaName, String tableName) {
        return this.session.getTableColumns(schemaName, tableName);
    }

    public boolean tableExists(String databaseName, String tableName) {
        return this.session.tableExists(databaseName, tableName);
    }

    public void createTable(String databaseName, String tableName, List<String> columnNames, List<String> columnTypes, List<String> primaryKeyColumns, List<String> uniqueKeyColumns, boolean ignoreExisting) {
        this.session.createTable(databaseName, tableName, columnNames, columnTypes, primaryKeyColumns, uniqueKeyColumns, ignoreExisting);
    }

    public void dropTable(String schemaName, String tableName, boolean ignoreIfNotExists) {
        this.session.dropTable(schemaName, tableName, ignoreIfNotExists);
    }

    public boolean databaseExists(String databaseName) {
        return this.session.databaseExists(databaseName);
    }

    public void createDatabase(String databaseName, boolean ignoreIfExists) {
        this.session.createDatabase(databaseName, ignoreIfExists);
    }

    public void dropDatabase(String schemaName, boolean ignoreIfNotExists) {
        this.session.dropDatabase(schemaName, ignoreIfNotExists);
    }

    public void renameTable(String oldDatabaseName, String newDatabaseName, String oldTableName, String newTableName) {
        this.session.renameTable(oldDatabaseName, newDatabaseName, oldTableName, newTableName);
    }

    public void addColumn(String databaseName, String tableName, String columnName, String columnType) {
        this.session.addColumn(databaseName, tableName, columnName, columnType);
    }

    public void renameColumn(String databaseName, String tableName, String oldName, String newName, String newType) {
        this.session.renameColumn(databaseName, tableName, oldName, newName, newType);
    }

    public void dropColumn(String databaseName, String tableName, String columnName) {
        this.session.dropColumn(databaseName, tableName, columnName);
    }

    public Connection getJdbcConnection() throws SQLException {
        return this.session.getJdbcConnection();
    }

    public List<String> getPrimaryKeyColumns(String databaseName, String tableName) {
        return this.session.getPrimaryKeyColumns(databaseName, tableName);
    }

    public List<String> getUniqueKeyColumns(String databaseName, String tableName) {
        return this.session.getUniqueKeyColumns(databaseName, tableName);
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("session", (Object)this.session).toString();
    }
}

