/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.tidb.bigdata.tidb.ColumnHandleInternal;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.tikv.common.operation.iterator.CoprocessorIterator;
import org.tikv.common.row.Row;
import org.tikv.common.types.DataType;

public class RecordCursorInternal {
    private final List<ColumnHandleInternal> columnHandles;
    private final CoprocessorIterator<Row> iterator;
    private Row row = null;

    public RecordCursorInternal(List<ColumnHandleInternal> columnHandles, CoprocessorIterator<Row> iterator) {
        this.columnHandles = columnHandles;
        this.iterator = iterator;
    }

    public DataType getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getType();
    }

    public boolean advanceNextPosition() {
        if (this.iterator.hasNext()) {
            this.row = (Row)this.iterator.next();
            return true;
        }
        return false;
    }

    public void close() {
    }

    public Object getObject(int field) {
        return this.row.get(field, null);
    }

    public BigDecimal getBigDecimal(int field) {
        return (BigDecimal)this.row.get(field, null);
    }

    public boolean isNull(int field) {
        return this.row.isNull(field);
    }

    public float getFloat(int field) {
        return (float)this.row.getDouble(field);
    }

    public boolean getBoolean(int field) {
        return (Boolean)this.row.get(field, null);
    }

    public byte getByte(int field) {
        return (byte)this.row.getLong(field);
    }

    public double getDouble(int field) {
        return this.row.getDouble(field);
    }

    public int getInteger(int field) {
        return (int)this.row.getLong(field);
    }

    public short getShort(int field) {
        return (short)this.row.getLong(field);
    }

    public long getLong(int field) {
        return this.row.getLong(field);
    }

    public long getUnsignedLong(int field) {
        return this.row.getUnsignedLong(field);
    }

    public String getString(int field) {
        return this.row.getString(field);
    }

    public Time getTime(int field) {
        return new Time(this.row.getLong(field) / 1000000L);
    }

    public Timestamp getTimestamp(int field) {
        return this.row.getTimestamp(field);
    }

    public Date getDate(int field) {
        return this.row.getDate(field);
    }

    public byte[] getBytes(int field) {
        return this.row.getBytes(field);
    }

    public int fieldCount() {
        return this.row.fieldCount();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columnHandles).toString();
    }
}

