/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import com.google.common.collect.ImmutableList;
import io.tidb.bigdata.tidb.Base64KeyRange;
import io.tidb.bigdata.tidb.ClientSession;
import io.tidb.bigdata.tidb.ColumnHandleInternal;
import io.tidb.bigdata.tidb.RecordCursorInternal;
import io.tidb.bigdata.tidb.SplitInternal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.tikv.common.expression.Expression;
import org.tikv.common.meta.TiDAGRequest;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.operation.iterator.CoprocessorIterator;
import org.tikv.common.row.Row;
import org.tikv.common.types.DataType;

public final class RecordSetInternal {
    private final List<ColumnHandleInternal> columnHandles;
    private final List<DataType> columnTypes;
    private final CoprocessorIterator<Row> iterator;

    public RecordSetInternal(ClientSession session, SplitInternal split, List<ColumnHandleInternal> columnHandles, Optional<Expression> expression, Optional<TiTimestamp> timestamp) {
        this(session, split, columnHandles, expression, timestamp, Integer.MAX_VALUE);
    }

    public RecordSetInternal(ClientSession session, SplitInternal split, List<ColumnHandleInternal> columnHandles, Optional<Expression> expression, Optional<TiTimestamp> timestamp, int limit) {
        Objects.requireNonNull(split, "split is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.columnTypes = (List)columnHandles.stream().map(ColumnHandleInternal::getType).collect(ImmutableList.toImmutableList());
        List columns = (List)columnHandles.stream().map(ColumnHandleInternal::getName).collect(ImmutableList.toImmutableList());
        TiDAGRequest.Builder request = session.request(split.getTable(), columns);
        request.setLimit(limit);
        expression.ifPresent(arg_0 -> ((TiDAGRequest.Builder)request).addFilter(arg_0));
        timestamp.ifPresent(arg_0 -> ((TiDAGRequest.Builder)request).setStartTs(arg_0));
        this.iterator = session.iterate(request, new Base64KeyRange(split.getStartKey(), split.getEndKey()));
    }

    public List<DataType> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursorInternal cursor() {
        return new RecordCursorInternal(this.columnHandles, this.iterator);
    }
}

